/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class PinpadDialog {
    private static int execMenuResult;
    private static AlertDialog execMenuDialog;

    PinpadDialog() {
    }

    private static int exec(Activity activity, String string, String[] stringArray, int n) {
        final Semaphore semaphore = new Semaphore(0);
        execMenuResult = -1;
        final AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        if (stringArray != null) {
            builder.setTitle((CharSequence)string);
            builder.setItems((CharSequence[])stringArray, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    execMenuResult = n;
                    semaphore.release();
                }
            });
        } else {
            TextView textView = new TextView((Context)activity);
            textView.setText((CharSequence)string);
            textView.setGravity(1);
            builder.setView((View)textView);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                execMenuDialog = builder.create();
                execMenuDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        semaphore.release();
                    }
                });
                execMenuDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        semaphore.release();
                    }
                });
                execMenuDialog.show();
            }
        });
        try {
            if (!semaphore.tryAcquire(n, TimeUnit.MILLISECONDS)) {
                execMenuDialog.dismiss();
                execMenuResult = -2;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n2 = execMenuResult;
        execMenuResult = -3;
        execMenuDialog = null;
        return n2;
    }

    static int execMenu(Activity activity, String string, String[] stringArray, int n) {
        return PinpadDialog.exec(activity, string, stringArray, n);
    }

    static int execMenu(Activity activity, String string, String[] stringArray) {
        return PinpadDialog.execMenu(activity, string, stringArray, 30000);
    }

    static int showMessage(Activity activity, String string, int n) {
        return PinpadDialog.exec(activity, string, null, n);
    }

    static String maskedPin(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("*");
        }
        return stringBuilder.toString();
    }

    static String pinScreen(long l, String string) {
        return "VALOR: " + String.format("%d,%02d", l / 100L, l % 100L) + "\nSENHA:\n" + string;
    }

    static String pinScreen(long l, int n) {
        return PinpadDialog.pinScreen(l, PinpadDialog.maskedPin(n));
    }
}

