/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.util.Log;
import androidx.annotation.Nullable;
import br.com.softwareexpress.sitef.android.CliSiTefI;
import br.com.softwareexpress.sitef.android.IPinPadDriver;
import br.com.softwareexpress.sitef.android.PinPadCtrl;
import br.com.softwareexpress.sitef.android.PinPadDriverReadResult;
import br.com.softwareexpress.sitef.android.StCode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;

abstract class PinPadDriverLib
implements IPinPadDriver {
    static final String LOGTAG = "PPDriverLib";
    private final PPBuffer ppCompResult = new PPBuffer();
    private String ppCompCmd;
    private Queue<String> notifyQueue = new LinkedList<String>();

    abstract int abortCmd();

    abstract CmdResult startCmd(String var1, byte[] var2);

    abstract CmdResult checkBlockingCmd(String var1, StringBuffer var2);

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void flush() {
        this.ppCompResult.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] byArray) {
        int n = byArray.length;
        if (byArray.length == 1) {
            if (byArray[0] == 24) {
                int n2 = this.abortCmd();
                if (n2 != 0) {
                    Log.e((String)LOGTAG, (String)("PP_Abort error: " + n2));
                    this.ppCompCmd = null;
                    n = -1;
                }
                this.ppCompResult.setByteResult((byte)4);
            } else if (byArray[0] == 21) {
                this.ppCompResult.reset();
            }
            return n;
        }
        if (byArray.length < 7) {
            throw new Error("Invalid PPComp input (" + byArray.length + ").");
        }
        this.ppCompCmd = new String(byArray, 1, 3, StandardCharsets.ISO_8859_1);
        CliSiTefI.log(LOGTAG, "cmd [" + this.ppCompCmd + "]");
        Object object = this.notifyQueue;
        synchronized (object) {
            this.notifyQueue.clear();
        }
        object = this.startCmd(this.ppCompCmd, byArray);
        this.ppCompResult.setResult(this.ppCompCmd, ((CmdResult)object).getPpStatus(), ((CmdResult)object).getPpOutput(), true);
        return n;
    }

    @Override
    public PinPadDriverReadResult<Byte> readCtrl(int n) {
        PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
        pinPadDriverReadResult.error = true;
        pinPadDriverReadResult.complete = false;
        pinPadDriverReadResult.data = null;
        Byte by = this.ppCompResult.readFirst();
        if (by == 4 || by == 6 || by == 21) {
            pinPadDriverReadResult.error = false;
            pinPadDriverReadResult.complete = true;
            pinPadDriverReadResult.data = by;
        }
        return pinPadDriverReadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PinPadDriverReadResult<Byte> readSyn(int n) {
        Byte by;
        PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
        pinPadDriverReadResult.error = true;
        pinPadDriverReadResult.complete = false;
        pinPadDriverReadResult.data = null;
        if (this.ppCompResult.length() == 0) {
            long l = System.currentTimeMillis();
            do {
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                Object object = this.notifyQueue;
                synchronized (object) {
                    if (!this.notifyQueue.isEmpty()) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(this.notifyQueue.remove());
                        bl = true;
                    }
                }
                object = !bl ? this.checkBlockingCmd(this.ppCompCmd, stringBuffer) : new CmdResult(StCode.PP_NOTIFY, stringBuffer, true);
                pinPadDriverReadResult.error = false;
                if (((CmdResult)object).getPpStatus() == StCode.PP_PROCESSING) {
                    pinPadDriverReadResult.complete = false;
                    if (n != -1) continue;
                    break;
                }
                if (((CmdResult)object).getPpStatus() == StCode.PP_NOTIFY) {
                    this.ppCompResult.setResult("NTM", StCode.ST_OK, ((CmdResult)object).getPpOutput(), false);
                    pinPadDriverReadResult.complete = true;
                    break;
                }
                this.ppCompResult.setResult(this.ppCompCmd, ((CmdResult)object).ppStatus, ((CmdResult)object).getPpOutput(), false);
                pinPadDriverReadResult.complete = true;
                break;
            } while (System.currentTimeMillis() - l < (long)n);
        }
        if ((by = this.ppCompResult.readFirst()) != null && by == 22) {
            pinPadDriverReadResult.error = false;
            pinPadDriverReadResult.complete = true;
            pinPadDriverReadResult.data = by;
        }
        return pinPadDriverReadResult;
    }

    @Override
    public PinPadDriverReadResult<byte[]> readData(int n) {
        boolean bl;
        PinPadDriverReadResult<byte[]> pinPadDriverReadResult = new PinPadDriverReadResult<byte[]>();
        pinPadDriverReadResult.error = false;
        pinPadDriverReadResult.complete = false;
        pinPadDriverReadResult.data = null;
        if (this.ppCompResult.length() == 0) {
            throw new Error("Invalid PIN pad response length");
        }
        pinPadDriverReadResult.complete = bl = this.ppCompResult.rewind(1);
        boolean bl2 = pinPadDriverReadResult.error = !pinPadDriverReadResult.complete;
        if (pinPadDriverReadResult.complete) {
            pinPadDriverReadResult.data = this.ppCompResult.read();
        }
        return pinPadDriverReadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceNotify(String string) {
        String string2 = string.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim().replaceAll("[^\\p{ASCII}]", "_");
        if (string2.length() > 32) {
            string2 = string2.substring(0, 32);
        }
        Queue<String> queue = this.notifyQueue;
        synchronized (queue) {
            this.notifyQueue.add(string2);
        }
    }

    static class CmdResult {
        private StCode ppStatus;
        private byte[] ppOutput;

        private void init(StCode stCode, @Nullable byte[] byArray) {
            this.ppOutput = byArray;
            this.ppStatus = stCode;
        }

        public CmdResult(StCode stCode, @Nullable byte[] byArray) {
            this.init(stCode, byArray);
        }

        public CmdResult(StCode stCode, @Nullable StringBuffer stringBuffer, boolean bl) {
            byte[] byArray;
            if (stringBuffer == null) {
                byArray = null;
            } else {
                int n = 0;
                if (bl) {
                    byArray = new byte[3 + stringBuffer.length()];
                    byte[] byArray2 = String.format("%03d", stringBuffer.length()).getBytes();
                    byArray[0] = byArray2[0];
                    byArray[1] = byArray2[1];
                    byArray[2] = byArray2[2];
                    n = 3;
                } else {
                    byArray = new byte[stringBuffer.length()];
                    n = 0;
                }
                System.arraycopy(stringBuffer.toString().getBytes(StandardCharsets.ISO_8859_1), 0, byArray, n, stringBuffer.length());
            }
            this.init(stCode, byArray);
        }

        public CmdResult(StCode stCode) {
            this.init(stCode, null);
        }

        @Nullable
        public byte[] getPpOutput() {
            return this.ppOutput;
        }

        @Nullable
        public String getPpOutputString() {
            return this.ppOutput == null ? null : new String(this.ppOutput, StandardCharsets.ISO_8859_1);
        }

        public StCode getPpStatus() {
            return this.ppStatus;
        }
    }

    private final class PPBuffer {
        private byte[] Buffer;
        private int ReadPos;

        PPBuffer() {
            this.clear();
        }

        void clear() {
            this.Buffer = new byte[0];
            this.ReadPos = 0;
        }

        void reset() {
            this.ReadPos = this.Buffer.length > 0 && this.Buffer[0] == 6 ? 1 : 0;
        }

        public int length() {
            return this.Buffer.length - this.ReadPos;
        }

        public void setByteResult(@Nullable Byte by) {
            this.ReadPos = 0;
            this.Buffer = by == null ? new byte[0] : new byte[]{by};
        }

        private byte[] adicionaCmdEStatus(String string, StCode stCode, byte[] byArray) {
            byte[] byArray2 = new byte[6 + byArray.length];
            int n = 0;
            byte[] byArray3 = string.getBytes(StandardCharsets.ISO_8859_1);
            for (int i = 0; i < 3; ++i) {
                byArray2[n++] = byArray3[i];
            }
            byte[] byArray4 = String.format(Locale.ENGLISH, "%03d", stCode.code()).getBytes(StandardCharsets.ISO_8859_1);
            for (int i = 0; i < 3; ++i) {
                byArray2[n++] = byArray4[i];
            }
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
            return byArray2;
        }

        private byte[] escapaCtrl(byte[] byArray) {
            byte[] byArray2 = new byte[6 + byArray.length * 2];
            int n = 0;
            block3: for (byte by : byArray) {
                switch (by) {
                    case 19: 
                    case 22: 
                    case 23: {
                        byArray2[n++] = 19;
                        byArray2[n++] = (byte)(by + 32);
                        continue block3;
                    }
                    default: {
                        byArray2[n++] = by;
                    }
                }
            }
            return Arrays.copyOfRange(byArray2, 0, n);
        }

        public void setResult(@Nullable String string, StCode stCode, byte[] byArray, boolean bl) {
            this.ReadPos = 0;
            if (string == null) {
                this.Buffer = new byte[]{21};
                return;
            }
            if (byArray == null) {
                if (stCode != StCode.ST_OK) {
                    byArray = new byte[]{};
                } else {
                    this.Buffer = bl ? new byte[]{6} : new byte[0];
                    return;
                }
            }
            if (stCode == StCode.PP_NOTIFY) {
                string = "NTM";
                stCode = StCode.ST_OK;
            }
            byte[] byArray2 = this.adicionaCmdEStatus(string, stCode, byArray);
            byte[] byArray3 = this.escapaCtrl(byArray2);
            short s = PinPadCtrl.crc16(byArray2, 0, byArray2.length, true);
            int n = 0;
            int n2 = 1 + byArray3.length + 1 + 2;
            if (bl) {
                ++n2;
            }
            this.Buffer = new byte[n2];
            if (bl) {
                this.Buffer[n++] = 6;
            }
            this.Buffer[n++] = 22;
            System.arraycopy(byArray3, 0, this.Buffer, n, byArray3.length);
            n += byArray3.length;
            this.Buffer[n++] = 23;
            this.Buffer[n++] = (byte)(s >> 8 & 0xFF);
            this.Buffer[n++] = (byte)(s & 0xFF);
        }

        public Byte readFirst() {
            Byte by = null;
            if (this.ReadPos < this.Buffer.length) {
                by = this.Buffer[this.ReadPos];
                if (by != 6 && by != 21 && by != 4 && by != 22) {
                    Log.e((String)PinPadDriverLib.LOGTAG, (String)("Unexpected byte: " + by.toString()));
                }
                ++this.ReadPos;
            }
            return by;
        }

        public boolean rewind(int n) {
            boolean bl = false;
            int n2 = this.ReadPos - n;
            if (n2 >= 0 && n2 < this.Buffer.length) {
                this.ReadPos = n2;
                bl = true;
            }
            return bl;
        }

        public byte[] read() {
            byte[] byArray = Arrays.copyOfRange(this.Buffer, this.ReadPos, this.Buffer.length);
            this.ReadPos = this.Buffer.length;
            return byArray;
        }
    }
}

