/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import br.com.softwareexpress.sitef.android.IPinPadDriver;
import br.com.softwareexpress.sitef.android.PinPadCtrl;
import br.com.softwareexpress.sitef.android.PinPadDriverReadResult;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;

final class PinPadDriverBT
implements IPinPadDriver {
    protected static final int OPERACAO_NENHUMA = 0;
    protected static final int OPERACAO_LEITURA_CTRL = 1;
    protected static final int OPERACAO_LEITURA_SYN = 2;
    protected static final int OPERACAO_LEITURA_DADOS = 3;
    protected static final int OPERACAO_ESCRITA = 4;
    protected static final int OPERACAO_FLUSH = 5;
    protected static final int OPERACAO_TERMINA_THREAD = 6;
    private Driver driver;
    private PinPadCtrl pinpad;

    private static boolean estaEntreAfixosSuportados(BluetoothDevice bluetoothDevice, String[] stringArray, boolean bl) {
        for (String string : stringArray) {
            boolean bl2 = false;
            bl2 = bl ? bluetoothDevice.getName().toUpperCase().startsWith(string.toUpperCase()) : bluetoothDevice.getName().toUpperCase().contains(string.toUpperCase());
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private static boolean estaEntreInfixosSuportados(BluetoothDevice bluetoothDevice, String[] stringArray) {
        return PinPadDriverBT.estaEntreAfixosSuportados(bluetoothDevice, stringArray, false);
    }

    private static boolean estaEntrePrefixosSuportados(BluetoothDevice bluetoothDevice, String[] stringArray) {
        return PinPadDriverBT.estaEntreAfixosSuportados(bluetoothDevice, stringArray, true);
    }

    static boolean deviceIsTipoBluetooth(BluetoothDevice bluetoothDevice) {
        String[] stringArray = new String[]{"PAX", "CIELO", "INGENICO", "ICMP", "MOBIPIN", "MP", "PP", "MOBILE", "MREDE"};
        String[] stringArray2 = new String[]{"ME30S"};
        return PinPadDriverBT.estaEntrePrefixosSuportados(bluetoothDevice, stringArray) || PinPadDriverBT.estaEntreInfixosSuportados(bluetoothDevice, stringArray2);
    }

    static boolean deviceIsTipoBluetoothLib(BluetoothDevice bluetoothDevice) {
        String[] stringArray = new String[]{"MOB65"};
        return PinPadDriverBT.estaEntrePrefixosSuportados(bluetoothDevice, stringArray);
    }

    public PinPadDriverBT(Context context, PinPadCtrl pinPadCtrl, BluetoothAdapter bluetoothAdapter) throws Exception {
        this.pinpad = pinPadCtrl;
        this.driver = new Driver(context, bluetoothAdapter);
    }

    public BluetoothDevice findDevice() {
        return this.driver.findDevice();
    }

    public void connectDevice() throws Exception {
        this.driver.Connect(null);
    }

    public void connectDevice(BluetoothDevice bluetoothDevice) throws Exception {
        this.driver.Connect(bluetoothDevice);
    }

    private void iniciaAguardaTratamento() {
        if (this.driver.running) {
            this.driver.processing = true;
            while (this.driver.processing) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    this.pinpad.trace("BTDriver", exception.getClass().getName() + " - " + exception.getMessage());
                }
            }
        }
    }

    @Override
    public IPinPadDriver.PinPadDriverFeatures getFeatures() {
        return new IPinPadDriver.PinPadDriverFeatures(IPinPadDriver.AbecsSupportLevel.ABECS_SUPPORT_2_ENCRYPTED, false);
    }

    @Override
    public boolean start() {
        this.driver.start();
        return true;
    }

    @Override
    public void terminate() {
        this.driver.operacao = 6;
        this.iniciaAguardaTratamento();
        this.driver = null;
    }

    @Override
    public void flush() {
        if (!this.driver.connected) {
            return;
        }
        this.driver.operacao = 5;
        this.iniciaAguardaTratamento();
    }

    @Override
    public int write(byte[] byArray) {
        if (!this.driver.connected) {
            return -1;
        }
        this.driver.input = byArray;
        this.driver.written = 0;
        this.driver.operacao = 4;
        this.driver.timeout = 0;
        this.iniciaAguardaTratamento();
        return this.driver.written;
    }

    @Override
    public PinPadDriverReadResult<Byte> readCtrl(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 1;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByte;
    }

    @Override
    public PinPadDriverReadResult<Byte> readSyn(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 2;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByte;
    }

    @Override
    public PinPadDriverReadResult<byte[]> readData(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<byte[]> pinPadDriverReadResult = new PinPadDriverReadResult<byte[]>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 3;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByteArray;
    }

    public static class FallbackException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FallbackException(Exception exception) {
            super(exception);
        }
    }

    public class FallbackBluetoothSocket
    extends NativeBluetoothSocket {
        private BluetoothSocket fallbackSocket;

        public FallbackBluetoothSocket(BluetoothSocket bluetoothSocket) throws FallbackException {
            super(bluetoothSocket);
            try {
                Class<?> clazz = bluetoothSocket.getRemoteDevice().getClass();
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = clazz.getMethod("createRfcommSocket", classArray);
                Object[] objectArray = new Object[]{1};
                this.fallbackSocket = (BluetoothSocket)method.invoke((Object)bluetoothSocket.getRemoteDevice(), objectArray);
            }
            catch (Exception exception) {
                throw new FallbackException(exception);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.fallbackSocket.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.fallbackSocket.getOutputStream();
        }

        @Override
        public void connect() throws IOException {
            this.fallbackSocket.connect();
        }

        @Override
        public void close() throws IOException {
            this.fallbackSocket.close();
        }
    }

    public static class NativeBluetoothSocket
    implements BluetoothSocketWrapper {
        private BluetoothSocket socket;

        public NativeBluetoothSocket(BluetoothSocket bluetoothSocket) {
            this.socket = bluetoothSocket;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.socket.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        @Override
        public String getRemoteDeviceName() {
            return this.socket.getRemoteDevice().getName();
        }

        @Override
        public void connect() throws IOException {
            this.socket.connect();
        }

        @Override
        public String getRemoteDeviceAddress() {
            return this.socket.getRemoteDevice().getAddress();
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }

        @Override
        public BluetoothSocket getUnderlyingSocket() {
            return this.socket;
        }
    }

    public static interface BluetoothSocketWrapper {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public String getRemoteDeviceName();

        public void connect() throws IOException;

        public String getRemoteDeviceAddress();

        public void close() throws IOException;

        public BluetoothSocket getUnderlyingSocket();
    }

    private class Driver
    extends Thread {
        private final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
        protected boolean processing;
        protected boolean connected;
        protected boolean running;
        protected int operacao;
        protected int timeout;
        protected byte[] readBuf;
        protected int readBufLength;
        protected PinPadDriverReadResult<Byte> readResultByte;
        protected PinPadDriverReadResult<byte[]> readResultByteArray;
        protected int written;
        protected boolean enableRecovery;
        protected byte[] input;
        private BluetoothAdapter btAdapter;
        private Context context;
        private BluetoothSocketWrapper socket;
        private DataInputStream in = null;
        private DataOutputStream out = null;
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String string = intent.getAction();
                PinPadDriverBT.this.pinpad.trace("Driver", "Evento " + string);
                if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(string) || "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED".equals(string)) {
                    Driver.this.connected = false;
                    PinPadDriverBT.this.pinpad.sendMessage(7);
                }
            }
        };

        public Driver(Context context, BluetoothAdapter bluetoothAdapter) throws Exception {
            this.context = context;
            this.btAdapter = bluetoothAdapter;
            this.processing = false;
            this.connected = false;
            this.running = false;
            this.enableRecovery = false;
            this.operacao = 0;
            this.input = null;
            this.readBuf = new byte[4160];
            this.readBufLength = 0;
            this.readResultByte = null;
            this.readResultByteArray = null;
        }

        public BluetoothDevice findDevice() {
            Set set;
            BluetoothDevice bluetoothDevice = null;
            if (!this.btAdapter.isEnabled()) {
                PinPadDriverBT.this.pinpad.sendMessage(1);
                this.btAdapter.enable();
                while (!this.btAdapter.isEnabled()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        PinPadDriverBT.this.pinpad.trace("BTDriver.enabled", exception.getClass().getName() + " - " + exception.getMessage());
                    }
                }
                PinPadDriverBT.this.pinpad.sendMessage(2);
            } else {
                this.btAdapter.cancelDiscovery();
            }
            if (this.btAdapter.isEnabled() && (set = this.btAdapter.getBondedDevices()).size() > 0) {
                String string = PinPadDriverBT.this.pinpad.getEndereco();
                String string2 = PinPadDriverBT.this.pinpad.getPrefixoNomeBluetooth();
                for (BluetoothDevice bluetoothDevice2 : set) {
                    if (string != null && string.length() > 0) {
                        if (bluetoothDevice2.getAddress().equalsIgnoreCase(string)) {
                            bluetoothDevice = bluetoothDevice2;
                        }
                    } else if (string2 != null && string2.length() > 0) {
                        if (bluetoothDevice2.getName().toUpperCase().startsWith(string2)) {
                            bluetoothDevice = bluetoothDevice2;
                        }
                    } else {
                        if ((PinPadDriverBT.this.pinpad.getTipoPinPad() == 2 || PinPadDriverBT.this.pinpad.getTipoPinPad() == 1) && PinPadDriverBT.deviceIsTipoBluetooth(bluetoothDevice2)) {
                            bluetoothDevice = bluetoothDevice2;
                        }
                        if ((PinPadDriverBT.this.pinpad.getTipoPinPad() == 5 || PinPadDriverBT.this.pinpad.getTipoPinPad() == 1) && PinPadDriverBT.deviceIsTipoBluetoothLib(bluetoothDevice2)) {
                            bluetoothDevice = bluetoothDevice2;
                        }
                    }
                    if (bluetoothDevice != null) {
                        PinPadDriverBT.this.pinpad.trace("BTDriver", "Selecionado: [" + bluetoothDevice2.getName() + "]");
                        break;
                    }
                    PinPadDriverBT.this.pinpad.trace("BTDriver", "Ignorando [" + bluetoothDevice2.getName() + "]");
                }
            }
            return bluetoothDevice;
        }

        private void Connect(BluetoothDevice bluetoothDevice) throws Exception {
            int n = -1;
            this.Disconnect();
            if (bluetoothDevice == null) {
                bluetoothDevice = this.findDevice();
            }
            if (bluetoothDevice != null) {
                PinPadDriverBT.this.pinpad.trace("BTDriver", "Tentando [" + bluetoothDevice.getName() + "]");
                if (bluetoothDevice.getName().toUpperCase().startsWith("INGENICO")) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.enableRecovery = bluetoothDevice.getName().toUpperCase().startsWith("MOBIPIN");
                this.socket = new NativeBluetoothSocket(bluetoothDevice.createRfcommSocketToServiceRecord(this.MY_UUID));
                try {
                    this.socket.connect();
                }
                catch (Exception exception) {
                    try {
                        this.socket = new FallbackBluetoothSocket(this.socket.getUnderlyingSocket());
                        Thread.sleep(500L);
                        this.socket.connect();
                    }
                    catch (Exception exception2) {
                        PinPadDriverBT.this.pinpad.trace("BTDriver", exception.getClass().getName() + " - " + exception.getMessage());
                        this.socket = null;
                    }
                }
                try {
                    if (this.socket != null) {
                        this.in = new DataInputStream(this.socket.getInputStream());
                        this.out = new DataOutputStream(this.socket.getOutputStream());
                        PinPadDriverBT.this.pinpad.trace("BTDriver", "Encontrado " + this.socket.getRemoteDeviceName() + " [" + this.socket.getRemoteDeviceAddress() + "]");
                        this.connected = true;
                        this.context.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
                        this.context.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED"));
                        n = 0;
                    }
                }
                catch (Exception exception) {
                    PinPadDriverBT.this.pinpad.trace("BTDriver", exception.getClass().getName() + " - " + exception.getMessage());
                }
            }
            if (n != 0) {
                throw new Exception("Nao encontrado pinpad BT compativel");
            }
        }

        private void Disconnect() {
            block8: {
                try {
                    this.context.unregisterReceiver(this.mReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    if (this.out != null) {
                        this.out.close();
                        this.out = null;
                    }
                    if (this.socket == null) break block8;
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                catch (Exception exception) {
                    PinPadDriverBT.this.pinpad.trace("BTDriver", exception.getClass().getName() + " - " + exception.getMessage());
                }
            }
            this.connected = false;
        }

        @Override
        public void run() {
            block37: {
                try {
                    this.running = true;
                    while (true) {
                        if (this.processing) {
                            block38: {
                                byte by;
                                if (!this.connected) {
                                    this.Connect(null);
                                    if (!this.connected) break block37;
                                }
                                if (this.operacao == 1) {
                                    PinPadDriverBT.this.pinpad.trace("Thr", "Lendo ACK/NAK/EOT");
                                    this.readResultByte = new PinPadDriverReadResult();
                                    this.readResultByte.error = false;
                                    this.readResultByte.complete = false;
                                    this.readResultByte.data = null;
                                    if (this.timeout < 0 || this.timeout == -1) {
                                        PinPadDriverBT.this.pinpad.trace("Thr", "Timeout obrigatorio");
                                        this.readResultByte.error = true;
                                        break;
                                    }
                                    long l = System.currentTimeMillis();
                                    while (true) {
                                        if (this.in.available() > 0 && ((by = (byte)this.in.readByte()) == 4 || by == 6 || by == 21)) {
                                            this.readResultByte.complete = true;
                                            this.readResultByte.data = by;
                                            PinPadDriverBT.this.pinpad.trace("Thr.Leu", "ACK/NAK/EOT");
                                            this.readBufLength = 0;
                                            break block38;
                                        }
                                        long l2 = System.currentTimeMillis();
                                        if (l2 - l > (long)this.timeout) {
                                            this.readResultByte.error = true;
                                            PinPadDriverBT.this.pinpad.trace("Thr", "Timeout ACK/NAK/EOT");
                                            break block38;
                                        }
                                        Driver.sleep(250L);
                                    }
                                }
                                if (this.operacao == 2) {
                                    PinPadDriverBT.this.pinpad.trace("Thr", "Lendo SYN");
                                    this.readResultByte = new PinPadDriverReadResult();
                                    this.readResultByte.error = false;
                                    this.readResultByte.complete = false;
                                    this.readResultByte.data = null;
                                    long l = System.currentTimeMillis();
                                    while (true) {
                                        if ((by = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength, 22)) >= 0) {
                                            if (by > 0) {
                                                System.arraycopy(this.readBuf, by, this.readBuf, 0, this.readBufLength - by);
                                                this.readBufLength -= by;
                                            }
                                            this.readResultByte.error = false;
                                            this.readResultByte.complete = true;
                                            this.readResultByte.data = (byte)22;
                                            break block38;
                                        }
                                        if (this.in.available() > 0) {
                                            int n = this.in.read(this.readBuf);
                                            if (n <= 0) {
                                                throw new IOException("Invalid state - DataInputStream.read() should not have returned end-of-file after DataInputStream.available() > 0");
                                            }
                                            this.readBufLength = n;
                                            continue;
                                        }
                                        if (this.timeout == -1) break block38;
                                        long l3 = System.currentTimeMillis();
                                        if (l3 - l > (long)this.timeout) {
                                            this.readResultByte.error = true;
                                            PinPadDriverBT.this.pinpad.trace("Thr", "Timeout SYN");
                                            break block38;
                                        }
                                        Driver.sleep(250L);
                                    }
                                }
                                if (this.operacao == 3) {
                                    PinPadDriverBT.this.pinpad.trace("Thr", "Lendo");
                                    this.readResultByteArray = new PinPadDriverReadResult();
                                    this.readResultByteArray.error = false;
                                    this.readResultByteArray.complete = false;
                                    this.readResultByteArray.data = null;
                                    if (this.timeout < 0 || this.timeout == -1) {
                                        PinPadDriverBT.this.pinpad.trace("Thr", "Timeout obrigatorio");
                                        this.readResultByteArray.error = true;
                                        break;
                                    }
                                    long l = System.currentTimeMillis();
                                    while (true) {
                                        by = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength - 3, 22);
                                        int n = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength - 2, 23);
                                        if (by >= 0 && n > by) {
                                            this.readResultByteArray.complete = true;
                                            this.readResultByteArray.data = Arrays.copyOfRange(this.readBuf, (int)by, n + 2 + 1);
                                            int n2 = PinPadCtrl.obtemIndiceCaractere(this.readBuf, n + 2, this.readBufLength, 22);
                                            if (n2 >= 0) {
                                                System.arraycopy(this.readBuf, n2, this.readBuf, 0, this.readBufLength - n2);
                                                this.readBufLength -= n2;
                                            } else {
                                                this.readBufLength = 0;
                                            }
                                            break block38;
                                        }
                                        if (this.readBuf.length <= this.readBufLength) {
                                            this.readResultByteArray.error = true;
                                            break block38;
                                        }
                                        if (this.in.available() > 0) {
                                            int n3 = this.in.read(this.readBuf, this.readBufLength, this.readBuf.length - this.readBufLength);
                                            if (n3 <= 0) {
                                                throw new IOException("Invalid state - DataInputStream.read() should not have returned end-of-file after DataInputStream.available() > 0");
                                            }
                                            this.readBufLength += n3;
                                            continue;
                                        }
                                        long l4 = System.currentTimeMillis();
                                        if (l4 - l > (long)this.timeout) {
                                            this.readResultByte.error = true;
                                            PinPadDriverBT.this.pinpad.trace("Thr", "Timeout");
                                            break block38;
                                        }
                                        Driver.sleep(250L);
                                    }
                                }
                                if (this.operacao == 4) {
                                    try {
                                        this.out.write(this.input, 0, this.input.length);
                                        this.out.flush();
                                        PinPadDriverBT.this.pinpad.trace("Thr.Escreveu", "" + this.input.length);
                                        this.written += this.input.length;
                                        this.readBufLength = 0;
                                    }
                                    catch (Exception exception) {
                                        if (this.enableRecovery) {
                                            this.Connect(null);
                                            if (!this.connected) {
                                                throw exception;
                                            }
                                            this.out.write(this.input, 0, this.input.length);
                                            this.out.flush();
                                            PinPadDriverBT.this.pinpad.trace("Thr.Escreveu", "" + this.input.length);
                                            this.written += this.input.length;
                                            this.readBufLength = 0;
                                        }
                                        throw exception;
                                    }
                                } else if (this.operacao == 5) {
                                    while (this.in.available() > 0) {
                                        this.in.read(this.readBuf);
                                        Driver.sleep(250L);
                                    }
                                    this.readBufLength = 0;
                                } else if (this.operacao == 6) break block37;
                            }
                            this.operacao = 0;
                            this.processing = false;
                            continue;
                        }
                        Driver.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    PinPadDriverBT.this.pinpad.trace("BTDriver", exception.getClass().getName() + " - " + exception.getMessage());
                }
            }
            PinPadDriverBT.this.pinpad.trace("Thr", "Finalizando");
            this.Disconnect();
            this.operacao = 0;
            this.processing = false;
            this.running = false;
        }
    }
}

