/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import androidx.annotation.Nullable;
import br.com.softwareexpress.sitef.android.IPPCompLib;
import br.com.softwareexpress.sitef.android.PPMessageHandler;
import com.ingenico.lar.bc.Pinpad;
import com.ingenico.lar.bc.PinpadCallbacks;
import com.ingenico.lar.bc.PinpadOutput;
import com.ingenico.lar.bc.PinpadOutputHandler;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class PPCompLibIngenicoRua
implements IPPCompLib {
    private static final String LOGTAG = "PPCompLibIngenicoRua";
    private static Pinpad ppcomp;
    MyPinpadOutputHandler startFuncOutputHandler;
    private String getInfoVersaoAplicacaoBasica = null;

    public PPCompLibIngenicoRua(final Activity activity, BluetoothDevice bluetoothDevice, final PPMessageHandler pPMessageHandler) {
        if (activity == null) {
            throw new NullPointerException("CliSiTef/PPCompLib: no Activity set (application must call CliSiTef/CliSiTefI.setActivity()).");
        }
        if (ppcomp == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("context", activity.getApplicationContext());
            hashMap.put("CBPeripheral", bluetoothDevice);
            ppcomp = Pinpad.Companion.build(hashMap, new PinpadCallbacks(){

                public int onShowMessage(int n, @Nullable String string) {
                    Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)("onShowMessage " + n + ", [" + string + "]"));
                    switch (n) {
                        case 1: {
                            if (string == null || !string.equals("CardInserted")) break;
                            pPMessageHandler.handleNotifyMessage("PROCESSANDO");
                            break;
                        }
                        case 12: {
                            pPMessageHandler.handleNotifyMessage("REMOVA O CARTAO");
                            break;
                        }
                        case 5: {
                            if (string == null) break;
                            pPMessageHandler.handleNotifyMessage(string);
                        }
                    }
                    return 0;
                }

                public int onShowPinEntry(int n, @Nullable String string, long l) {
                    Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)("onShowPinEntry " + n + ", [" + string + "], amount:" + l));
                    switch (n) {
                        case 15: {
                            pPMessageHandler.handleNotifyMessage("SOLICITE\u00b7A\u00b7SENHA");
                            break;
                        }
                        case 7: {
                            pPMessageHandler.handleNotifyMessage("SENHA INVALIDA");
                            break;
                        }
                        case 8: {
                            pPMessageHandler.handleNotifyMessage("PROXIMO ERRO BLOQUEIA SENHA");
                        }
                    }
                    return 0;
                }

                public void onAbort() {
                }

                public void onShowMenu(int n, final @Nullable String string, final @Nullable String[] stringArray, final @Nullable PinpadCallbacks.MenuResult menuResult) {
                    Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)("onShowMenu " + n + ", " + string + ", " + (stringArray != null ? Integer.valueOf(stringArray.length) : "null")));
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CharSequence[] charSequenceArray = stringArray;
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                            builder.setTitle((CharSequence)(string != null ? string : "SELECIONE:"));
                            builder.setItems(charSequenceArray, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int n) {
                                    Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)("selected: " + n + "." + stringArray[n]));
                                    if (menuResult != null) {
                                        menuResult.setResult(0, n);
                                    }
                                }
                            });
                            AlertDialog alertDialog = builder.create();
                            alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                                public void onCancel(DialogInterface dialogInterface) {
                                    if (menuResult != null) {
                                        menuResult.setResult(13, 0);
                                    }
                                }
                            });
                            alertDialog.show();
                        }
                    });
                }
            });
        }
    }

    private int execBlockingFunc(Func func) {
        return this.execBlockingFunc(null, func);
    }

    private int execBlockingFunc(StringBuffer stringBuffer, Func func) {
        MyPinpadOutputHandler myPinpadOutputHandler = new MyPinpadOutputHandler();
        int n = func.exec(myPinpadOutputHandler);
        if (n == 0) {
            return myPinpadOutputHandler.waitForPinpadOutput(stringBuffer);
        }
        return n;
    }

    private int execStartFunc(String string, Func func) {
        this.startFuncOutputHandler = new MyPinpadOutputHandler(string);
        return func.exec(this.startFuncOutputHandler);
    }

    private int execFunc(String string, @Nullable StringBuffer stringBuffer, @Nullable StringBuffer stringBuffer2) {
        return this.startFuncOutputHandler.checkForStartFuncPinpadOutput(string, stringBuffer, stringBuffer2);
    }

    private int execFunc(String string, StringBuffer stringBuffer) {
        return this.execFunc(string, stringBuffer, null);
    }

    private int execFunc(String string) {
        return this.execFunc(string, null, null);
    }

    @Override
    public int PP_Open() {
        return this.execBlockingFunc(new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.open(pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_Close(final String string) {
        return this.execBlockingFunc(new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.close(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_Abort() {
        ppcomp.abort();
        return 0;
    }

    @Override
    public int PP_GetInfo(final String string, StringBuffer stringBuffer) {
        int n = this.execBlockingFunc(stringBuffer, new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.getInfo(string, pinpadOutputHandler);
            }
        });
        if (n != 0 && n != 15 && !string.equals("00") && string.matches("\\d\\d")) {
            CharSequence charSequence;
            int n2;
            Log.d((String)LOGTAG, (String)("Contornando GetInfo de rede (" + string + ")."));
            String string2 = "0";
            if (this.getInfoVersaoAplicacaoBasica == null && (n2 = this.PP_GetInfo("00", (StringBuffer)(charSequence = new StringBuffer()))) == 0) {
                this.getInfoVersaoAplicacaoBasica = charSequence.substring(64, 77);
                Log.d((String)LOGTAG, (String)("GetInfo VersaoAplicacaoBasica=[" + this.getInfoVersaoAplicacaoBasica + "]"));
            }
            if (this.getInfoVersaoAplicacaoBasica != null) {
                string2 = this.getInfoVersaoAplicacaoBasica;
            }
            if (string.equals("01")) {
                stringBuffer.append(String.format("%-20s%-13s%-7s00", "AMERICAN EXPRESS", string2, "1.06a03"));
            } else if (string.equals("02")) {
                stringBuffer.append(String.format("%-8s%-12s%-13s%-7s00", "REDECARD", "0", string2, "1.06a02"));
            } else if (string.equals("03")) {
                charSequence = " ";
                StringBuffer stringBuffer2 = new StringBuffer();
                int n3 = this.PP_GetDUKPT("301", stringBuffer2);
                if (n3 == 0) {
                    charSequence = "T";
                }
                stringBuffer.append(String.format("%-20s%-13s%-6s%s00", "CIELO", string2, "107b01", charSequence));
            } else {
                stringBuffer.append(String.format("%-20s%-13s%-7s00", "ADQ" + string, string2, "1.08"));
            }
            n = 0;
        }
        return n;
    }

    @Override
    public int PP_Display(final String string) {
        return this.execBlockingFunc(new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.display(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_DisplayEx(final String string) {
        return this.execBlockingFunc(new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.displayEx(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_StartGetKey() {
        return this.execStartFunc("GKY", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.getKey(pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_GetKey() {
        return this.execFunc("GKY");
    }

    @Override
    public int PP_StartGetPIN(final String string) {
        return this.execStartFunc("GPN", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.getPIN(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_GetPIN(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.execFunc("GPN", stringBuffer, stringBuffer2);
    }

    @Override
    public int PP_StartCheckEvent(final String string) {
        return this.execStartFunc("CKE", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.checkEvent(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_CheckEvent(StringBuffer stringBuffer) {
        return this.execFunc("CKE", stringBuffer);
    }

    @Override
    public int PP_StartRemoveCard(final String string) {
        return this.execStartFunc("RMC", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.removeCard(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_RemoveCard(StringBuffer stringBuffer) {
        return this.execFunc("RMC", null, stringBuffer);
    }

    @Override
    public int PP_StartGetCard(final String string) {
        return this.execStartFunc("GCR", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.getCard(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_GetCard(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.execFunc("GCR", stringBuffer, stringBuffer2);
    }

    @Override
    public int PP_ResumeGetCard() {
        return ppcomp.resumeGetCard();
    }

    @Override
    public int PP_StartGoOnChip(final String string, final String string2, final String string3) {
        return this.execStartFunc("GOC", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.goOnChip(string, string2, string3, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_GoOnChip(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.execFunc("GOC", stringBuffer, stringBuffer2);
    }

    @Override
    public int PP_FinishChip(final String string, final String string2, StringBuffer stringBuffer) {
        return this.execBlockingFunc(stringBuffer, new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.finishChip(string, string2, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_ChangeParameter(final String string) {
        return this.execBlockingFunc(new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.changeParameter(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_EncryptBuffer(final String string, StringBuffer stringBuffer) {
        return this.execBlockingFunc(stringBuffer, new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.encryptBuffer(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_DefineWKPAN(final String string, StringBuffer stringBuffer) {
        return this.execBlockingFunc(stringBuffer, new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.defineWKPAN(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_TableLoadInit(String string) {
        return ppcomp.tableLoadInit(string);
    }

    @Override
    public int PP_TableLoadRec(String string) {
        return ppcomp.tableLoadRec(string);
    }

    @Override
    public int PP_TableLoadEnd() {
        return ppcomp.tableLoadEnd();
    }

    @Override
    public int PP_GetTimeStamp(String string, StringBuffer stringBuffer) {
        PinpadOutput pinpadOutput = ppcomp.getTimeStamp(string);
        if (pinpadOutput.getResultCode() == 0) {
            stringBuffer.append(pinpadOutput.getResult());
        }
        return pinpadOutput.getResultCode();
    }

    @Override
    public int PP_GetDUKPT(final String string, StringBuffer stringBuffer) {
        return this.execBlockingFunc(stringBuffer, new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.getDUKPT(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_StartGenericCmd(final String string) {
        return this.execStartFunc("GEN", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.genericCmd(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_GenericCmd(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.execFunc("GEN", stringBuffer, stringBuffer2);
    }

    @Override
    public int PP_StartChipDirect(final String string) {
        return this.execStartFunc("CHP", new Func(){

            @Override
            public int exec(PinpadOutputHandler pinpadOutputHandler) {
                return ppcomp.chipDirect(string, pinpadOutputHandler);
            }
        });
    }

    @Override
    public int PP_ChipDirect(StringBuffer stringBuffer) {
        return this.execFunc("CHP", stringBuffer);
    }

    private static interface Func {
        public int exec(PinpadOutputHandler var1);
    }

    private class MyPinpadOutputHandler
    implements PinpadOutputHandler {
        @Nullable
        private final String startCmd;
        private PinpadOutput pinpadOutput;
        private final Semaphore semaphore;

        MyPinpadOutputHandler(String string) {
            this.startCmd = string;
            this.semaphore = new Semaphore(0);
        }

        MyPinpadOutputHandler() {
            this(null);
        }

        public synchronized void onPinpadResult(PinpadOutput pinpadOutput) {
            Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)("onPinpadResult " + pinpadOutput));
            this.pinpadOutput = pinpadOutput;
            this.semaphore.release();
        }

        private int waitForPinpadOutput(StringBuffer stringBuffer) {
            try {
                Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)"Wait for onPinpadResult.");
                this.semaphore.tryAcquire(40000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)"onPinpadResult semaphore interrupted.");
            }
            if (this.pinpadOutput != null) {
                if (stringBuffer != null) {
                    stringBuffer.append(this.pinpadOutput.getResult());
                }
                return this.pinpadOutput.getResultCode();
            }
            Log.d((String)PPCompLibIngenicoRua.LOGTAG, (String)"onPinpadResult timed out.");
            return 31;
        }

        public int checkForStartFuncPinpadOutput(String string, @Nullable StringBuffer stringBuffer, @Nullable StringBuffer stringBuffer2) {
            if (this.startCmd != null && !this.startCmd.equals(string)) {
                return 10;
            }
            if (this.pinpadOutput == null) {
                return 1;
            }
            if (stringBuffer != null) {
                if (this.startCmd != null && !this.startCmd.equals(this.pinpadOutput.getCommand())) {
                    return 10;
                }
                stringBuffer.append(this.pinpadOutput.getResult());
            }
            return this.pinpadOutput.getResultCode();
        }
    }
}

