/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import br.com.softwareexpress.sitef.android.CliSiTefI;
import br.com.softwareexpress.sitef.android.FuncoesInternas;
import br.com.softwareexpress.sitef.android.ICliSiTefListener;
import br.com.softwareexpress.sitef.android.ModuleBarcode;
import br.com.softwareexpress.sitef.android.ModulePinPad;
import br.com.softwareexpress.sitef.android.modules.IBarcode;
import br.com.softwareexpress.sitef.android.modules.IPinPad;

public final class CliSiTef {
    public static final int CONFIG_OK = 0;
    public static final int CONFIG_ERROR_INVALID_SITEF_ADDRESS = 1;
    public static final int CONFIG_ERROR_INVALID_STORE_ID = 2;
    public static final int CONFIG_ERROR_INVALID_TERMINAL_ID = 3;
    public static final int CONFIG_ERROR_MISSING_COLLECT_FUNCTION = 4;
    public static final int CONFIG_ERROR_MISSING_RECEIVE_FUNCTION = 5;
    public static final int CONFIG_ERROR_TCPIP_SETUP = 6;
    public static final int CONFIG_ERROR_OUT_OF_MEMORY = 7;
    public static final int CONFIG_ERROR_CLISITEF_LIBRARY_NOT_FOUND = 8;
    public static final int CONFIG_ERROR_MAX_SITEF_IP_REACHED = 9;
    public static final int CONFIG_ERROR_INITIALIZING_FILES = 10;
    public static final int CONFIG_ERROR_INVALID_FIELD = 11;
    public static final int CONFIG_ERROR_SECURE_MODE = 12;
    public static final int CONFIG_ERROR_INVALID_PATH = 13;
    public static final int CMD_RESULT_DATA = 0;
    public static final int CMD_SHOW_MSG_CASHIER = 1;
    public static final int CMD_SHOW_MSG_CUSTOMER = 2;
    public static final int CMD_SHOW_MSG_CASHIER_CUSTOMER = 3;
    public static final int CMD_SHOW_MENU_TITLE = 4;
    public static final int CMD_CLEAR_MSG_CASHIER = 11;
    public static final int CMD_CLEAR_MSG_CUSTOMER = 12;
    public static final int CMD_CLEAR_MSG_CASHIER_CUSTOMER = 13;
    public static final int CMD_CLEAR_MENU_TITLE = 14;
    public static final int CMD_SHOW_HEADER = 15;
    public static final int CMD_CLEAR_HEADER = 16;
    public static final int CMD_CONFIRM_GO_BACK = 19;
    public static final int CMD_CONFIRMATION = 20;
    public static final int CMD_GET_MENU_OPTION = 21;
    public static final int CMD_PRESS_ANY_KEY = 22;
    public static final int CMD_ABORT_REQUEST = 23;
    public static final int CMD_GET_FIELD_INTERNAL = 29;
    public static final int CMD_GET_FIELD = 30;
    public static final int CMD_GET_FIELD_CHEQUE = 31;
    public static final int CMD_GET_FIELD_TRACK = 32;
    public static final int CMD_GET_FIELD_PASSWORD = 33;
    public static final int CMD_GET_FIELD_CURRENCY = 34;
    public static final int CMD_GET_FIELD_BARCODE = 35;
    public static final int CMD_GET_PINPAD_CONFIRMATION = 37;
    public static final int CMD_GET_MASKED_FIELD = 41;
    public static final int CMD_SHOW_QRCODE_FIELD = 50;
    public static final int CMD_REMOVE_QRCODE_FIELD = 51;
    public static final int CMD_MESSAGE_QRCODE = 52;
    public static final int EVT_BEGIN_BT_STARTUP = 1;
    public static final int EVT_END_BT_STARTUP = 2;
    public static final int EVT_BEGIN_PP_CONNECT = 3;
    public static final int EVT_END_PP_CONNECT = 4;
    public static final int EVT_BEGIN_PP_CONFIG = 5;
    public static final int EVT_END_PP_CONFIG = 6;
    public static final int EVT_BT_PP_DISCONNECT = 7;
    public final IPinPad pinpad;
    public final IBarcode barcode;
    private static CliSiTef instance = null;
    private final CliSiTefI clisitefi;
    private ICliSiTefListener listener = null;
    private final FuncoesInternas funcInternas;
    private String currentFiscalDoc = null;
    private String currentFiscalDate = null;
    private String currentFiscalTime = null;

    public CliSiTef(Context context) {
        instance = this;
        this.clisitefi = new CliSiTefI(context);
        this.funcInternas = new FuncoesInternas(this.clisitefi, this.listener);
        this.pinpad = new ModulePinPad(this.clisitefi);
        this.barcode = new ModuleBarcode(this.clisitefi);
    }

    public static synchronized CliSiTef getInstance() {
        return instance;
    }

    public final void setDebug(boolean bl) {
        this.clisitefi.setDebug(bl);
    }

    public void setMessageHandler(Handler handler) {
        this.clisitefi.setMessageHandler(handler);
    }

    public final String getBuffer() {
        return this.clisitefi.getBuffer();
    }

    public final void setBuffer(String string) {
        this.clisitefi.setBuffer(string);
    }

    public final void setContinueFlag(int n) {
        this.clisitefi.setContinuaNavegacao(n);
    }

    public final int getCommand() {
        return this.clisitefi.getProximoComando();
    }

    public final int getFieldId() {
        return this.clisitefi.getTipoCampo();
    }

    public final short getMaxLength() {
        return this.clisitefi.getTamanhoMaximo();
    }

    public final short getMinLength() {
        return this.clisitefi.getTamanhoMinimo();
    }

    public String getCliSiTefVersion() {
        return this.clisitefi.getVersaoCliSiTef();
    }

    public String getCliSiTefIVersion() {
        return this.clisitefi.getVersaoCliSiTefI();
    }

    public int loadTranslationFile(String string) {
        return this.clisitefi.carregaArquivosTraducao(string);
    }

    public int loadTranslationFile(String string, String string2) {
        return this.clisitefi.carregaArquivosTraducao(string, string2);
    }

    public int configure(String string, String string2, String string3, String string4) {
        return this.clisitefi.configuraIntSiTefInterativoEx(string, string2, string3, string4);
    }

    public synchronized int startTransaction(ICliSiTefListener iCliSiTefListener, int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.listener = iCliSiTefListener;
        this.funcInternas.setListener(iCliSiTefListener);
        int n2 = this.clisitefi.iniciaFuncaoSiTefInterativo(n, string, string2, string3, string4, string5, string6 == null ? "" : string6);
        if (n2 == 10000) {
            this.currentFiscalDoc = string2;
            this.currentFiscalDate = string3;
            this.currentFiscalTime = string4;
            n2 = this.funcInternas.processoIterativo(1, n2);
        }
        return n2;
    }

    public synchronized int abortTransaction(int n) {
        return this.funcInternas.abortTransaction(n);
    }

    public synchronized int continueTransaction(String string) {
        return this.funcInternas.continueTransaction(string);
    }

    @Deprecated
    public synchronized int finishTransaction(int n, String string, String string2, String string3, String string4) {
        int n2 = this.clisitefi.finalizaTransacaoSiTefInterativoEx((short)n, string, string2, string3, string4);
        if (n2 == 10000) {
            n2 = this.funcInternas.processoIterativo(2, n2);
        }
        return n2;
    }

    public synchronized int finishTransaction(ICliSiTefListener iCliSiTefListener, int n, String string, String string2, String string3, String string4) {
        this.listener = iCliSiTefListener;
        this.funcInternas.setListener(iCliSiTefListener);
        int n2 = this.clisitefi.finalizaTransacaoSiTefInterativoEx((short)n, string, string2, string3, string4);
        if (n2 == 10000) {
            n2 = this.funcInternas.processoIterativo(2, n2);
        }
        return n2;
    }

    public synchronized int finishTransaction(int n) throws Exception {
        if (this.currentFiscalDoc == null || this.currentFiscalDate == null || this.currentFiscalTime == null) {
            throw new Exception("Last transaction made not found.");
        }
        int n2 = this.finishTransaction(n, this.currentFiscalDoc, this.currentFiscalDate, this.currentFiscalTime, "");
        return n2;
    }

    public int getQttPendingTransactions(String string, String string2) throws Exception {
        return this.clisitefi.obtemQuantidadeTransacoesPendentes(string, string2);
    }

    public String getVersion() throws Exception {
        int n = this.clisitefi.obtemVersao();
        if (n != 0) {
            throw new Exception("getVersion returned [" + n + "].");
        }
        return this.clisitefi.getVersaoCliSiTef() + "/" + this.clisitefi.getVersaoCliSiTefI();
    }

    public int submitPendingMessages() {
        return this.clisitefi.descarregaMensagens();
    }

    public void setActivity(Activity activity) {
        this.clisitefi.setActivity(activity);
    }

    public int sendReceiveSiTefDirectly(short s, short s2, short s3, byte[] byArray, short s4, short s5, short s6, String string, String string2, String string3, String string4, short s7) {
        return this.clisitefi.enviaRecebeSiTefDireto(s, s2, s3, byArray, s4, s5, s6, string, string2, string3, string4, s7);
    }

    public final short getResponseCode() {
        return this.clisitefi.getCodigoResposta();
    }

    public final byte[] getRxData() {
        return this.clisitefi.getDadosRx();
    }

    public int setSendReceiveSiTefDirectlyParameter(short s, String string, short s2, short s3) {
        return this.clisitefi.forneceParametroExecutaEnviaRecebeSiTefDireto(s, string, s2, s3);
    }

    public int execSendReceiveSiTefDirectly(short s, short s2, short s3, String string, String string2, String string3, String string4, short s4) {
        return this.clisitefi.executaEnviaRecebeSiTefDireto(s, s2, s3, string, string2, string3, string4, s4);
    }

    public int getSendReceiveSiTefDirectlyResult(short s) {
        return this.clisitefi.obtemRetornoExecutaEnviaRecebeSiTefDireto(s);
    }

    public final String getServiceCode() {
        return this.clisitefi.getCodigoServico();
    }

    public final String getServiceData() {
        return this.clisitefi.getDadosServico();
    }

    public int readCardDirectly(String string) {
        return this.clisitefi.leCartaoDireto(string);
    }

    public int stopReadCardDirectly() {
        return this.clisitefi.interrompeLeCartaoDireto();
    }

    public String getTrack1() {
        return this.clisitefi.getTrilha1();
    }

    public String getTrack2() {
        return this.clisitefi.getTrilha2();
    }

    public int closePinPad() {
        return this.clisitefi.fechaPinPad();
    }
}

