/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

enum SpeCode {
    SPE_UNKNOWN(-1),
    SPE_IDLIST(1),
    SPE_MTHDPIN(2),
    SPE_MTHDDAT(3),
    SPE_TAGLIST(4),
    SPE_EMVDATA(5),
    SPE_CEXOPT(6),
    SPE_TRACKS(7),
    SPE_OPNDIG(8),
    SPE_KEYIDX(9),
    SPE_WKENC(10),
    SPE_MSGIDX(11),
    SPE_TIMEOUT(12),
    SPE_MINDIG(13),
    SPE_MAXDIG(14),
    SPE_DATAIN(15),
    SPE_ACQREF(16),
    SPE_APPTYPE(17),
    SPE_AIDLIST(18),
    SPE_AMOUNT(19),
    SPE_CASHBACK(20),
    SPE_TRNDATE(21),
    SPE_TRNTIME(22),
    SPE_GCXOPT(23),
    SPE_GOXOPT(24),
    SPE_FCXOPT(25),
    SPE_TRMPAR(26),
    SPE_DSPMSG(27),
    SPE_ARC(28),
    SPE_IVCBC(29),
    SPE_MFNAME(30),
    SPE_MFINFO(31),
    SPE_MNUOPT(32),
    SPE_TRNTYPE(33),
    SPE_TRNCURR(34),
    SPE_PANMASK(35),
    SPE_PBKMOD(36),
    SPE_PBKEXP(37);

    private final int code;
    private static final Map<Integer, SpeCode> map;

    public static SpeCode valueOf(int n) {
        if (map.containsKey(n)) {
            return map.get(n);
        }
        return SPE_UNKNOWN;
    }

    private SpeCode(int n2) {
        this.code = n2;
    }

    public int code() {
        return this.code;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s(%04Xh)", this.name(), this.code);
    }

    static {
        map = new HashMap<Integer, SpeCode>();
        for (SpeCode speCode : SpeCode.values()) {
            map.put(speCode.code, speCode);
        }
    }
}

