/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import br.com.softwareexpress.sitef.android.IPinPadDriver;
import br.com.softwareexpress.sitef.android.PinPadCtrl;
import br.com.softwareexpress.sitef.android.PinPadDriverReadResult;
import java.util.Arrays;
import java.util.HashMap;

final class PinPadDriverUSB
implements IPinPadDriver {
    protected static final int OPERACAO_NENHUMA = 0;
    protected static final int OPERACAO_LEITURA_CTRL = 1;
    protected static final int OPERACAO_LEITURA_SYN = 2;
    protected static final int OPERACAO_LEITURA_DADOS = 3;
    protected static final int OPERACAO_ESCRITA = 4;
    protected static final int OPERACAO_FLUSH = 5;
    protected static final int OPERACAO_TERMINA_THREAD = 6;
    protected static final int OPERACAO_VALIDA_PERMISSAO_USB = 7;
    protected static final int OPERACAO_ABRE_CONEXAO_USB = 8;
    private Driver driver;
    private PinPadCtrl pinpad;

    PinPadDriverUSB(Context context, PinPadCtrl pinPadCtrl) throws Exception {
        this.pinpad = pinPadCtrl;
        this.driver = new Driver(context);
    }

    private void iniciaAguardaTratamento() {
        this.driver.processing = true;
        while (this.driver.processing) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                this.pinpad.trace("USBDriver", exception.getClass().getName() + " - " + exception.getMessage());
            }
        }
    }

    @Override
    public IPinPadDriver.PinPadDriverFeatures getFeatures() {
        return new IPinPadDriver.PinPadDriverFeatures(IPinPadDriver.AbecsSupportLevel.ABECS_SUPPORT_2_ENCRYPTED, false);
    }

    @Override
    public boolean start() {
        boolean bl;
        this.driver.start();
        this.driver.operacao = 8;
        this.iniciaAguardaTratamento();
        if (this.driver.mUsbCon == null) {
            this.driver = null;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void terminate() {
        if (this.driver != null) {
            this.driver.operacao = 6;
            this.iniciaAguardaTratamento();
            this.driver = null;
        }
    }

    @Override
    public void flush() {
        if (this.driver == null || !this.driver.connected) {
            return;
        }
        this.driver.operacao = 5;
        this.iniciaAguardaTratamento();
    }

    @Override
    public int write(byte[] byArray) {
        if (this.driver == null || !this.driver.connected) {
            return -1;
        }
        this.driver.input = byArray;
        this.driver.written = 0;
        this.driver.operacao = 4;
        this.driver.timeout = 0;
        this.iniciaAguardaTratamento();
        return this.driver.written;
    }

    @Override
    public PinPadDriverReadResult<Byte> readCtrl(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 1;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByte;
    }

    @Override
    public PinPadDriverReadResult<Byte> readSyn(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<Byte> pinPadDriverReadResult = new PinPadDriverReadResult<Byte>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 2;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByte;
    }

    @Override
    public PinPadDriverReadResult<byte[]> readData(int n) {
        if (!this.driver.connected) {
            PinPadDriverReadResult<byte[]> pinPadDriverReadResult = new PinPadDriverReadResult<byte[]>();
            pinPadDriverReadResult.error = true;
            return pinPadDriverReadResult;
        }
        this.driver.operacao = 3;
        this.driver.timeout = n;
        this.iniciaAguardaTratamento();
        return this.driver.readResultByteArray;
    }

    private class Driver
    extends Thread {
        private static final String ACTION_USB_PERMISSION = "com.android.pinpad.USB_PERMISSION";
        protected boolean processing;
        protected boolean connected = false;
        protected int operacao;
        protected int timeout;
        protected byte[] readBuf;
        protected int readBufLength;
        protected PinPadDriverReadResult<Byte> readResultByte;
        protected PinPadDriverReadResult<byte[]> readResultByteArray;
        protected int written;
        protected byte[] input;
        private int interfaceIndex = 1;
        private int requestType = 64;
        protected boolean aguardandoPermissao;
        protected Context context = null;
        protected UsbManager mUsbManager = null;
        protected UsbDevice mUsbDevice = null;
        protected UsbInterface mUsbInterface = null;
        protected UsbDeviceConnection mUsbCon = null;
        protected UsbEndpoint mUsbEndpR = null;
        protected UsbEndpoint mUsbEndpW = null;
        private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String string = intent.getAction();
                if (Driver.ACTION_USB_PERMISSION.equals(string)) {
                    Driver.this.aguardandoPermissao = false;
                    context.unregisterReceiver((BroadcastReceiver)this);
                }
            }
        };
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String string = intent.getAction();
                PinPadDriverUSB.this.pinpad.trace("onRec", "Recebeu evento " + string);
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string)) {
                    Driver.this.connected = false;
                    PinPadDriverUSB.this.pinpad.sendMessage(7);
                }
            }
        };

        public Driver(Context context) throws Exception {
            IntentFilter intentFilter;
            HashMap hashMap;
            this.context = context;
            this.processing = false;
            this.aguardandoPermissao = false;
            this.operacao = 0;
            this.input = null;
            this.readBuf = new byte[4160];
            this.readBufLength = 0;
            this.readResultByte = null;
            this.readResultByteArray = null;
            this.mUsbManager = (UsbManager)context.getSystemService("usb");
            Intent intent = new Intent(context.getApplicationContext(), context.getClass());
            this.mUsbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (this.mUsbDevice == null) {
                hashMap = this.mUsbManager.getDeviceList();
                intentFilter = hashMap.values().iterator();
                while (this.mUsbDevice == null && intentFilter.hasNext()) {
                    UsbDevice usbDevice = (UsbDevice)intentFilter.next();
                    int n = usbDevice.getVendorId();
                    int n2 = usbDevice.getProductId();
                    PinPadDriverUSB.this.pinpad.trace("Constr", String.format("Vendor: %x; ProductId: %x", n, n2));
                    if (n == 1947 && n2 == 40) {
                        this.interfaceIndex = 1;
                        this.mUsbDevice = usbDevice;
                        break;
                    }
                    if (n == 2816) {
                        switch (n2) {
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 97: 
                            case 98: 
                            case 102: {
                                this.interfaceIndex = 1;
                                this.mUsbDevice = usbDevice;
                            }
                        }
                        continue;
                    }
                    if (n == 5971) {
                        switch (n2) {
                            default: 
                        }
                        this.interfaceIndex = 1;
                        this.mUsbDevice = usbDevice;
                        continue;
                    }
                    if (n == 4660 && n2 == 257) {
                        this.interfaceIndex = 0;
                        this.mUsbDevice = usbDevice;
                        break;
                    }
                    if (n != 4554) continue;
                    switch (n2) {
                        case 519: 
                        case 537: {
                            this.interfaceIndex = 1;
                            this.mUsbDevice = usbDevice;
                        }
                    }
                }
            }
            if (this.mUsbDevice == null) {
                throw new Exception("Nao encontrado pinpad USB compativel");
            }
            if (!this.mUsbManager.hasPermission(this.mUsbDevice)) {
                hashMap = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
                intentFilter = new IntentFilter(ACTION_USB_PERMISSION);
                context.registerReceiver(this.mUsbReceiver, intentFilter);
                this.mUsbManager.requestPermission(this.mUsbDevice, (PendingIntent)hashMap);
                this.aguardandoPermissao = true;
            }
        }

        @Override
        public void run() {
            block50: {
                try {
                    this.context.registerReceiver(this.mReceiver, new IntentFilter("android.hardware.usb.action.USB_DEVICE_DETACHED"));
                    while (true) {
                        if (this.processing && !this.aguardandoPermissao) {
                            block51: {
                                int n;
                                if (this.operacao != 8 && !this.connected) break block50;
                                if (this.operacao == 1) {
                                    PinPadDriverUSB.this.pinpad.trace("Thr", "Lendo ACK/NAK/EOT");
                                    this.readResultByte = new PinPadDriverReadResult();
                                    this.readResultByte.error = false;
                                    this.readResultByte.complete = false;
                                    this.readResultByte.data = null;
                                    if (this.timeout <= 0 || this.timeout == -1) {
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Timeout obrigatorio");
                                        this.readResultByte.error = true;
                                        break;
                                    }
                                    block5: do {
                                        if ((n = this.mUsbCon.bulkTransfer(this.mUsbEndpR, this.readBuf, this.mUsbEndpR.getMaxPacketSize(), this.timeout)) <= 0) {
                                            this.readResultByte.error = true;
                                            if (n == 0) {
                                                PinPadDriverUSB.this.pinpad.trace("Thr", "Timeout ACK/NAK/EOT");
                                            } else {
                                                PinPadDriverUSB.this.pinpad.trace("Thr", "Erro na leitura: " + n);
                                            }
                                            break;
                                        }
                                        for (byte by : this.readBuf) {
                                            if (by != 4 && by != 6 && by != 21) continue;
                                            this.readResultByte.error = false;
                                            this.readResultByte.complete = true;
                                            this.readResultByte.data = by;
                                            this.readBufLength = 0;
                                            continue block5;
                                        }
                                    } while (!this.readResultByte.complete);
                                } else {
                                    int n2;
                                    if (this.operacao == 2) {
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Lendo SYN");
                                        this.readResultByte = new PinPadDriverReadResult();
                                        this.readResultByte.error = false;
                                        this.readResultByte.complete = false;
                                        this.readResultByte.data = null;
                                        while (true) {
                                            if ((n = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength, 22)) >= 0) {
                                                if (n > 0) {
                                                    System.arraycopy(this.readBuf, n, this.readBuf, 0, this.readBufLength - n);
                                                    this.readBufLength -= n;
                                                }
                                                this.readResultByte.error = false;
                                                this.readResultByte.complete = true;
                                                this.readResultByte.data = (byte)22;
                                                break block51;
                                            }
                                            int n3 = this.mUsbCon.bulkTransfer(this.mUsbEndpR, this.readBuf, this.readBuf.length, this.timeout == -1 ? 250 : this.timeout);
                                            if (n3 <= 0) {
                                                if (this.timeout != -1) {
                                                    this.readResultByte.error = true;
                                                    PinPadDriverUSB.this.pinpad.trace("Thr", "Erro na leitura ou timeout: " + n3);
                                                }
                                                break block51;
                                            }
                                            this.readBufLength = n3;
                                        }
                                    }
                                    if (this.operacao == 3) {
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Lendo");
                                        this.readResultByteArray = new PinPadDriverReadResult();
                                        this.readResultByteArray.error = false;
                                        this.readResultByteArray.complete = false;
                                        this.readResultByteArray.data = null;
                                        if (this.timeout < 0 || this.timeout == -1) {
                                            PinPadDriverUSB.this.pinpad.trace("Thr", "Timeout obrigatorio");
                                            this.readResultByteArray.error = true;
                                            break;
                                        }
                                        while (true) {
                                            n = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength - 3, 22);
                                            int n4 = PinPadCtrl.obtemIndiceCaractere(this.readBuf, 0, this.readBufLength - 2, 23);
                                            if (n >= 0 && n4 > n) {
                                                this.readResultByteArray.complete = true;
                                                this.readResultByteArray.data = Arrays.copyOfRange(this.readBuf, n, n4 + 2 + 1);
                                                n2 = PinPadCtrl.obtemIndiceCaractere(this.readBuf, n4 + 2, this.readBufLength, 22);
                                                if (n2 >= 0) {
                                                    System.arraycopy(this.readBuf, n2, this.readBuf, 0, this.readBufLength - n2);
                                                    this.readBufLength -= n2;
                                                } else {
                                                    this.readBufLength = 0;
                                                }
                                                break block51;
                                            }
                                            if (this.readBuf.length <= this.readBufLength) {
                                                this.readResultByteArray.error = true;
                                                break block51;
                                            }
                                            if (this.readBuf.length > 16384) {
                                                throw new UnsupportedOperationException("mUsbCon.bulkTransfer nao aceita buffers acima de 16k - fazer particionamento");
                                            }
                                            n2 = this.mUsbCon.bulkTransfer(this.mUsbEndpR, this.readBuf, this.readBufLength, this.readBuf.length - this.readBufLength, this.timeout);
                                            if (n2 <= 0) {
                                                this.readResultByte.error = true;
                                                PinPadDriverUSB.this.pinpad.trace("Thr", "Erro na leitura ou timeout nao esperado: " + n2);
                                                break block51;
                                            }
                                            PinPadDriverUSB.this.pinpad.trace("Thr.Leu", "" + n2);
                                            this.readBufLength += n2;
                                        }
                                    }
                                    if (this.operacao == 4) {
                                        this.written = 0;
                                        n = this.input.length % this.mUsbEndpW.getMaxPacketSize() == 0 ? 1 : 0;
                                        int n5 = n != 0 ? this.input.length - 1 : this.input.length;
                                        n2 = this.mUsbCon.bulkTransfer(this.mUsbEndpW, this.input, n5, 0);
                                        if (n2 != n5) {
                                            PinPadDriverUSB.this.pinpad.trace("Thr", "Erro na escrita: " + n2);
                                            this.written = -1;
                                            break;
                                        }
                                        PinPadDriverUSB.this.pinpad.trace("Thr.Escreveu", "" + n2);
                                        this.written += n2;
                                        Driver.sleep(10L);
                                        if (n != 0) {
                                            n2 = this.mUsbCon.bulkTransfer(this.mUsbEndpW, this.input, this.input.length - 1, 1, 0);
                                            if (n2 != 1) {
                                                PinPadDriverUSB.this.pinpad.trace("Thr", "Erro na escrita: " + n2);
                                                this.written = -1;
                                                break;
                                            }
                                            PinPadDriverUSB.this.pinpad.trace("Thr.Escreveu", "" + n2);
                                            this.written += n2;
                                            Driver.sleep(10L);
                                        }
                                        this.readBufLength = 0;
                                    } else if (this.operacao == 5) {
                                        n = 0;
                                        this.mUsbCon.controlTransfer(this.requestType, 0, 1, 0, null, 0, 0);
                                        this.mUsbCon.controlTransfer(this.requestType, 0, 2, 0, null, 0, 0);
                                        byte[] byArray = new byte[this.mUsbEndpR.getMaxPacketSize()];
                                        while ((n = this.mUsbCon.bulkTransfer(this.mUsbEndpR, byArray, byArray.length, 250)) > 0) {
                                        }
                                        this.readBufLength = 0;
                                    } else if (this.operacao == 8) {
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Abrindo disp");
                                        this.mUsbCon = this.mUsbManager.openDevice(this.mUsbDevice);
                                        if (this.mUsbCon == null) {
                                            throw new Exception("USBDriver: Erro abrindo conexao com pinpad");
                                        }
                                        if (this.interfaceIndex >= this.mUsbDevice.getInterfaceCount()) {
                                            throw new Exception("USBDriver: Numero de Interface invalido" + this.interfaceIndex + "/" + this.mUsbDevice.getInterfaceCount());
                                        }
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Abrindo itfce 0");
                                        this.mUsbInterface = this.mUsbDevice.getInterface(0);
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Solicitando itfce");
                                        if (!this.mUsbCon.claimInterface(this.mUsbInterface, true)) {
                                            throw new Exception("USBDriver: Erro na solicitacao de Interface 0");
                                        }
                                        this.mUsbCon.controlTransfer(this.requestType, 0, 0, 0, null, 0, 0);
                                        this.mUsbCon.controlTransfer(this.requestType, 0, 2, 0, null, 0, 0);
                                        this.mUsbCon.controlTransfer(this.requestType, 2, 0, 0, null, 0, 0);
                                        this.mUsbCon.controlTransfer(this.requestType, 3, 32771, 0, null, 0, 0);
                                        if (this.interfaceIndex != 0) {
                                            this.mUsbCon.releaseInterface(this.mUsbInterface);
                                            PinPadDriverUSB.this.pinpad.trace("Thr", "Abrindo itfce " + this.interfaceIndex);
                                            this.mUsbInterface = this.mUsbDevice.getInterface(this.interfaceIndex);
                                            PinPadDriverUSB.this.pinpad.trace("Thr", "Solicitando itfce");
                                            if (!this.mUsbCon.claimInterface(this.mUsbInterface, true)) {
                                                throw new Exception("USBDriver: Erro na solicitacao de Interface " + this.interfaceIndex);
                                            }
                                        }
                                        for (n = 0; n < this.mUsbInterface.getEndpointCount(); ++n) {
                                            UsbEndpoint usbEndpoint = this.mUsbInterface.getEndpoint(n);
                                            if (usbEndpoint.getType() != 2) continue;
                                            if (usbEndpoint.getDirection() == 128) {
                                                this.mUsbEndpR = usbEndpoint;
                                                continue;
                                            }
                                            this.mUsbEndpW = usbEndpoint;
                                        }
                                        if (this.mUsbEndpR == null || this.mUsbEndpW == null) {
                                            throw new Exception("USBDriver: Endpoints invalidos para interface " + this.interfaceIndex);
                                        }
                                        PinPadDriverUSB.this.pinpad.trace("Thr", "Pronto");
                                        this.connected = true;
                                    } else if (this.operacao == 6) break block50;
                                }
                            }
                            this.operacao = 0;
                            this.processing = false;
                            continue;
                        }
                        Driver.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    PinPadDriverUSB.this.pinpad.trace("USBDriver", exception.getClass().getName() + " - " + exception.getMessage());
                }
            }
            PinPadDriverUSB.this.pinpad.trace("Thr.Finalizando", "");
            try {
                this.context.unregisterReceiver(this.mReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mUsbEndpW = null;
            this.mUsbEndpR = null;
            if (this.mUsbCon != null) {
                this.mUsbCon.releaseInterface(this.mUsbInterface);
                this.mUsbCon.close();
                this.mUsbCon = null;
            }
            this.operacao = 0;
            this.connected = false;
            this.processing = false;
        }
    }
}

