/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import br.com.softwareexpress.sitef.android.IPPCompLib;
import br.com.softwareexpress.sitef.android.IPinPadDriver;
import br.com.softwareexpress.sitef.android.PinPadDriverLib;
import br.com.softwareexpress.sitef.android.StCode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

abstract class PinPadDriverLibBc
extends PinPadDriverLib {
    static final String LOGTAG = "PPDriverLib/Bc";
    private IPPCompLib ppCompLib;

    PinPadDriverLibBc() {
    }

    public static boolean isImplemented() {
        return true;
    }

    void setPpCompLib(IPPCompLib iPPCompLib) {
        this.ppCompLib = iPPCompLib;
    }

    @Override
    public IPinPadDriver.PinPadDriverFeatures getFeatures() {
        return new IPinPadDriver.PinPadDriverFeatures(IPinPadDriver.AbecsSupportLevel.ABECS_SUPPORT_0_NONE, true);
    }

    @Override
    int abortCmd() {
        return this.ppCompLib.PP_Abort();
    }

    private static String[] extraiParametros(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += 3 + n) {
            n = Integer.parseInt(string.substring(i, i + 3));
            arrayList.add(string.substring(i + 3, i + 3 + n));
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    PinPadDriverLib.CmdResult startCmd(String string, byte[] byArray) {
        String[] stringArray = PinPadDriverLibBc.extraiParametros(new String(byArray, 4, byArray.length - 7, StandardCharsets.ISO_8859_1));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (string.equals("OPN")) {
            n = this.ppCompLib.PP_Open();
        } else if (string.equals("CLO")) {
            n = this.ppCompLib.PP_Close(stringArray[0]);
        } else if (string.equals("DSP")) {
            n = this.ppCompLib.PP_Display(stringArray[0]);
        } else if (string.equals("DEX")) {
            n = this.ppCompLib.PP_DisplayEx(stringArray[0]);
        } else if (string.equals("GKY")) {
            n = this.ppCompLib.PP_StartGetKey();
            stringBuffer = null;
        } else if (string.equals("GPN")) {
            n = this.ppCompLib.PP_StartGetPIN(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("RMC")) {
            n = this.ppCompLib.PP_StartRemoveCard(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("GEN")) {
            n = this.ppCompLib.PP_StartGenericCmd(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("CKE")) {
            n = this.ppCompLib.PP_StartCheckEvent(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("GCR")) {
            n = stringArray.length == 0 ? this.ppCompLib.PP_ResumeGetCard() : this.ppCompLib.PP_StartGetCard(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("GOC")) {
            n = this.ppCompLib.PP_StartGoOnChip(stringArray[0], stringArray[1], stringArray[2]);
            stringBuffer = null;
        } else if (string.equals("FNC")) {
            n = this.ppCompLib.PP_FinishChip(stringArray[0], stringArray[1], stringBuffer);
        } else if (string.equals("CHP")) {
            n = this.ppCompLib.PP_StartChipDirect(stringArray[0]);
            stringBuffer = null;
        } else if (string.equals("CNG")) {
            n = this.ppCompLib.PP_ChangeParameter(stringArray[0]);
        } else if (string.equals("GIN")) {
            n = this.ppCompLib.PP_GetInfo(stringArray[0], stringBuffer);
        } else if (string.equals("ENB")) {
            n = this.ppCompLib.PP_EncryptBuffer(stringArray[0], stringBuffer);
        } else if (string.equals("TLI")) {
            n = this.ppCompLib.PP_TableLoadInit(stringArray[0]);
        } else if (string.equals("TLR")) {
            n = this.ppCompLib.PP_TableLoadRec(stringArray[0]);
        } else if (string.equals("TLE")) {
            n = this.ppCompLib.PP_TableLoadEnd();
        } else if (string.equals("GDU")) {
            n = this.ppCompLib.PP_GetDUKPT(stringArray[0], stringBuffer);
        } else if (string.equals("GTS")) {
            n = this.ppCompLib.PP_GetTimeStamp(stringArray[0], stringBuffer);
        } else if (string.equals("DWK")) {
            n = this.ppCompLib.PP_DefineWKPAN(stringArray[0], stringBuffer);
        } else {
            throw new Error("PPDriverLib/Bc: Unknown PP command: " + string);
        }
        return new PinPadDriverLib.CmdResult(StCode.valueOf(n), stringBuffer, true);
    }

    @Override
    PinPadDriverLib.CmdResult checkBlockingCmd(String string, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        long l = System.currentTimeMillis() + 200L;
        do {
            if (string.equals("GCR")) {
                n = this.ppCompLib.PP_GetCard(stringBuffer2, stringBuffer);
                continue;
            }
            if (string.equals("GPN")) {
                n = this.ppCompLib.PP_GetPIN(stringBuffer2, stringBuffer);
                continue;
            }
            if (string.equals("RMC")) {
                n = this.ppCompLib.PP_RemoveCard(stringBuffer);
                stringBuffer2.setLength(0);
                continue;
            }
            if (string.equals("GOC")) {
                n = this.ppCompLib.PP_GoOnChip(stringBuffer2, stringBuffer);
                continue;
            }
            if (string.equals("GKY")) {
                n = this.ppCompLib.PP_GetKey();
                stringBuffer2.setLength(0);
                continue;
            }
            if (string.equals("CKE")) {
                n = this.ppCompLib.PP_CheckEvent(stringBuffer2);
                continue;
            }
            if (string.equals("CHP")) {
                n = this.ppCompLib.PP_ChipDirect(stringBuffer2);
                continue;
            }
            if (string.equals("GEN")) {
                n = this.ppCompLib.PP_GenericCmd(stringBuffer2, stringBuffer);
                continue;
            }
            throw new Error("Unknown PP command: " + string);
        } while (n == 1 && System.currentTimeMillis() < l);
        return new PinPadDriverLib.CmdResult(StCode.valueOf(n), stringBuffer2, true);
    }
}

