/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import br.com.softwareexpress.sitef.android.IPinPadDriver;
import br.com.softwareexpress.sitef.android.PPMessageHandler;
import br.com.softwareexpress.sitef.android.PinPadCtrlLogger;
import br.com.softwareexpress.sitef.android.PinPadDriverBT;
import br.com.softwareexpress.sitef.android.PinPadDriverLibApos;
import br.com.softwareexpress.sitef.android.PinPadDriverLibMobile;
import br.com.softwareexpress.sitef.android.PinPadDriverReadResult;
import br.com.softwareexpress.sitef.android.PinPadDriverUSB;
import java.nio.charset.StandardCharsets;

final class PinPadCtrl {
    private static final String LOGTAG = "PinPadCtrl";
    static final int TAM_MAX_PACOTE_ABECS = 4160;
    static final byte SERIAL_EOT04 = 4;
    static final byte SERIAL_ACK06 = 6;
    static final byte SERIAL_DC212 = 18;
    static final byte SERIAL_DC313 = 19;
    static final byte SERIAL_NAK15 = 21;
    static final byte SERIAL_SYN16 = 22;
    static final byte SERIAL_ETB17 = 23;
    static final byte SERIAL_CAN18 = 24;
    static final byte SERIAL_DC333 = 51;
    static final byte SERIAL_SYN36 = 54;
    static final byte SERIAL_ETB37 = 55;
    private static final short MSK_CRC_16 = 4129;
    static final int PPCOMP_OK = 0;
    static final int PPCOMP_PROCESSING = 1;
    static final int PPCOMP_NOTIFY = 2;
    static final int PPCOMP_NOSEC = 3;
    static final int PPCOMP_F1 = 4;
    static final int PPCOMP_F2 = 5;
    static final int PPCOMP_F3 = 6;
    static final int PPCOMP_F4 = 7;
    static final int PPCOMP_BACKSP = 8;
    static final int PPCOMP_ERRPKTSEC = 9;
    static final int PPCOMP_INVCALL = 10;
    static final int PPCOMP_INVPARM = 11;
    static final int PPCOMP_TIMEOUT = 12;
    static final int PPCOMP_CANCEL = 13;
    static final int PPCOMP_ALREADYOPEN = 14;
    static final int PPCOMP_NOTOPEN = 15;
    static final int PPCOMP_EXECERR = 16;
    static final int PPCOMP_INVMODEL = 17;
    static final int PPCOMP_NOFUNC = 18;
    static final int PPCOMP_ERRMANDAT = 19;
    static final int PPCOMP_TABEXP = 20;
    static final int PPCOMP_TABERR = 21;
    static final int PPCOMP_NOAPPLIC = 22;
    static final int PPCOMP_PORTERR = 30;
    static final int PPCOMP_COMMERR = 31;
    static final int PPCOMP_UNKNOWNSTAT = 32;
    static final int PPCOMP_RSPERR = 33;
    static final int PPCOMP_COMMTOUT = 34;
    static final int PPCOMP_DATANOTFOUND = 35;
    static final int PPCOMP_INTERR = 40;
    static final int PPCOMP_MCDATAERR = 41;
    static final int PPCOMP_ERRPIN = 42;
    static final int PPCOMP_NOCARD = 43;
    static final int PPCOMP_PINBUSY = 44;
    static final int PPCOMP_RSPOVRFL = 45;
    static final int PPCOMP_SAMERR = 50;
    static final int PPCOMP_NOSAM = 51;
    static final int PPCOMP_SAMINV = 52;
    static final int PPCOMP_DUMBCARD = 60;
    static final int PPCOMP_ERRCARD = 61;
    static final int PPCOMP_CARDINV = 62;
    static final int PPCOMP_CARDBLOCKED = 63;
    static final int PPCOMP_CARDNAUTH = 64;
    static final int PPCOMP_CARDEXPIRED = 65;
    static final int PPCOMP_CARDERRSTRUCT = 66;
    static final int PPCOMP_CARDINVALIDAT = 67;
    static final int PPCOMP_CARDPROBLEMS = 68;
    static final int PPCOMP_CARDINVDATA = 69;
    static final int PPCOMP_CARDAPPNAV = 70;
    static final int PPCOMP_CARDAPPNAUT = 71;
    static final int PPCOMP_NOBALANCE = 72;
    static final int PPCOMP_LIMITEXC = 73;
    static final int PPCOMP_CARDNOTEFFECT = 74;
    static final int PPCOMP_VCINVCURR = 75;
    static final int PPCOMP_ERRFALLBACK = 76;
    static final int PPCOMP_INVAMOUNT = 77;
    static final int PPCOMP_ERRMAXAID = 78;
    static final int PPCOMP_CTLSSMULTIPLE = 80;
    static final int PPCOMP_CTLSSCOMMERR = 81;
    static final int PPCOMP_CTLSSINVALIDAT = 82;
    static final int PPCOMP_CTLSSPROBLEMS = 83;
    static final int PPCOMP_CTLSSAPPNAV = 84;
    static final int PPCOMP_CTLSSAPPNAUT = 85;
    static final int PPCOMP_MFNFOUND = 100;
    static final int PPCOMP_MFERRFMT = 101;
    static final int PPCOMP_MFERR = 102;
    static final int PPCOMP_ERR = 1000;
    static final int PPCOMP_JNIERR = 8001;
    static final int PPCOMP_PARAMNULLERR = 8050;
    static final int TIMEOUT_MS_ACK_NAK_EOT = 2000;
    static final int TIMEOUT_MS_NAO_BLOCANTE = -1;
    static final int TIMEOUT_MS_SYN_NAO_BLOCANTE = -1;
    static final int TIMEOUT_MS_SYN_BLOCANTE = 10000;
    static final int TIMEOUT_MS_OUTROS = 2000;
    private static BluetoothAdapter btAdapter;
    private static IPinPadDriver driver;
    private int tipoPinPad = 0;
    protected byte[] msgBuffer = null;
    private final Context context;
    private Activity activity;
    private final PinPadCtrlLogger logger;
    private final PPMessageHandler ppMessageHandler;
    private boolean visualAccessibility;
    private Handler hndMessage = null;
    private boolean pinpadFechado = true;
    private int tipoConexao = 0;
    private String endereco = null;
    private String prefixoNomeBluetooth = null;
    private boolean modoBlocante;
    private boolean aguardaSyn;

    public PinPadCtrl(Context context, PinPadCtrlLogger pinPadCtrlLogger, PPMessageHandler pPMessageHandler) {
        try {
            btAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        catch (Exception exception) {
            this.traceException(exception);
        }
        this.context = context;
        this.logger = pinPadCtrlLogger;
        this.ppMessageHandler = pPMessageHandler;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setTipoPinPad(int n) {
        if (this.tipoPinPad != n) {
            this.PPDesconecta(true);
        }
        this.tipoPinPad = n;
    }

    public int getTipoPinPad() {
        return this.tipoPinPad;
    }

    public void setEndereco(String string) {
        this.endereco = string;
    }

    public String getEndereco() {
        return this.endereco == null ? "" : this.endereco;
    }

    public void setPrefixoNomeBluetooth(String string) {
        this.prefixoNomeBluetooth = string;
    }

    public String getPrefixoNomeBluetooth() {
        return this.prefixoNomeBluetooth == null ? "" : this.prefixoNomeBluetooth;
    }

    public int getTipoConexao() {
        return this.tipoConexao;
    }

    public void setVisualAccessibility(boolean bl) {
        this.visualAccessibility = bl;
    }

    public void setModoBlocante(boolean bl) {
        this.modoBlocante = bl;
    }

    @NonNull
    public IPinPadDriver.PinPadDriverFeatures getPinPadDriverFeatures() {
        if (driver == null) {
            this.logger.trace(LOGTAG, "Erro de implementacao: getPinPadDriverFeatures chamado sem PinPadDriver.");
        }
        return driver.getFeatures();
    }

    public boolean getSuporteAbecs() {
        if (driver == null) {
            return false;
        }
        return driver.getFeatures().getAbecsSupportLevel() != IPinPadDriver.AbecsSupportLevel.ABECS_SUPPORT_0_NONE;
    }

    public int PPConecta() {
        int n = -43;
        if (driver != null) {
            this.pinpadFechado = false;
            return 0;
        }
        if (this.endereco != null && (this.endereco.equalsIgnoreCase("NENHUM") || this.endereco.equalsIgnoreCase("NONE"))) {
            return 30;
        }
        try {
            IPinPadDriver iPinPadDriver;
            this.sendMessage(3);
            this.trace("PPConecta", "Procurando " + (this.endereco == null ? "qualquer MAC" : this.endereco));
            driver = null;
            this.tipoConexao = 0;
            if (driver == null && (this.tipoPinPad == 4 || this.tipoPinPad == 1)) {
                this.trace("PPConecta", "Tentando APOS");
                if (PinPadDriverLibApos.isImplemented()) {
                    iPinPadDriver = new PinPadDriverLibApos(this.activity, this.ppMessageHandler, this.visualAccessibility);
                    this.tipoConexao = 4;
                    driver = iPinPadDriver;
                } else {
                    this.trace("PPConecta", "APOS nao disponivel nesta versao da CliSiTef.");
                }
            }
            if (driver == null && (this.tipoPinPad == 3 || this.tipoPinPad == 1)) {
                this.trace("PPConecta", "Tentando USB");
                if (Build.VERSION.SDK_INT >= 12) {
                    try {
                        driver = new PinPadDriverUSB(this.context, this);
                        this.tipoConexao = 1;
                    }
                    catch (Exception exception) {
                        this.traceException("PPConecta.USB", exception);
                    }
                } else {
                    this.trace("PPConecta.USB", "Versao do SDK nao suportada [" + Build.VERSION.SDK_INT + "]");
                }
            }
            if (driver == null && (this.tipoPinPad == 2 || this.tipoPinPad == 5 || this.tipoPinPad == 1)) {
                this.trace("PPConecta", "Tentando Bluetooth");
                try {
                    iPinPadDriver = new PinPadDriverBT(this.context, this, btAdapter);
                    BluetoothDevice bluetoothDevice = ((PinPadDriverBT)iPinPadDriver).findDevice();
                    if (bluetoothDevice != null) {
                        if (PinPadDriverBT.deviceIsTipoBluetoothLib(bluetoothDevice)) {
                            this.trace("PPConecta", "Moby/6500 detectado, carregando biblioteca Ingenico BC/RUA.");
                            this.tipoConexao = 3;
                            driver = new PinPadDriverLibMobile(this.activity, bluetoothDevice, this.ppMessageHandler);
                        } else {
                            this.tipoConexao = 2;
                            ((PinPadDriverBT)iPinPadDriver).connectDevice(bluetoothDevice);
                            driver = iPinPadDriver;
                        }
                    } else {
                        this.trace("PPConecta", "Nenhum dos dispositivos pareados foi reconhecido como pinpad compativel.");
                    }
                }
                catch (Throwable throwable) {
                    this.traceException("PPConecta.BT", throwable);
                }
            }
            if (driver == null) {
                this.trace("PPConecta", "nenhum pinpad encontrado");
            } else if (driver.start()) {
                this.trace("PPConecta", "Conectado");
                this.sendMessage(4);
                this.sendMessage(5);
                this.sendMessage(6);
                this.pinpadFechado = false;
                n = 0;
            } else {
                this.trace("PPConecta", "pinpad nao conectado");
                driver = null;
                this.tipoConexao = 0;
                this.sendMessage(4);
            }
        }
        catch (Exception exception) {
            this.traceException(exception);
            this.PPDesconecta(true);
        }
        return n;
    }

    public int PPDesconecta(boolean bl) {
        int n = -43;
        this.pinpadFechado = true;
        if (bl && driver != null) {
            this.trace("PPDesconecta", "Fechando PinPad");
            driver.terminate();
            driver = null;
            this.tipoConexao = 0;
            this.sendMessage(7);
        }
        return n;
    }

    public int PPAborta() {
        int n = 31;
        if (this.pinpadFechado || driver == null) {
            n = 15;
        } else {
            try {
                n = 31;
                for (int i = 3; i > 0; --i) {
                    driver.flush();
                    int n2 = driver.write(new byte[]{24});
                    if (n2 != 1) {
                        this.trace("PPAborta", "Erro escrita");
                        return 31;
                    }
                    PinPadDriverReadResult<Byte> pinPadDriverReadResult = driver.readCtrl(2000);
                    if (pinPadDriverReadResult.error) {
                        this.trace("PPAborta", "Erro leitura");
                        return 31;
                    }
                    if (!pinPadDriverReadResult.complete || (Byte)pinPadDriverReadResult.data != 4) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    this.trace("PPEnvia", "Erro != EOT");
                }
            }
            catch (Exception exception) {
                this.traceException("PPAborta", exception);
                n = 31;
            }
        }
        return n;
    }

    public int PPEnvia(byte[] byArray) {
        int n = 0;
        if (this.pinpadFechado || driver == null) {
            n = 15;
        } else if (byArray != null) {
            try {
                n = 31;
                for (int i = 3; i > 0; --i) {
                    driver.flush();
                    int n2 = driver.write(byArray);
                    if (n2 != byArray.length) {
                        this.trace("PPEnvia", "Erro escrita");
                        return 31;
                    }
                    PinPadDriverReadResult<Byte> pinPadDriverReadResult = driver.readCtrl(20000);
                    if (pinPadDriverReadResult.error) {
                        this.trace("PPEnvia", "Erro leitura ACK/NAK");
                        return 31;
                    }
                    if (!pinPadDriverReadResult.complete) {
                        this.trace("PPEnvia", "Timeout leitura ACK/NAK");
                        return 31;
                    }
                    byte by = (Byte)pinPadDriverReadResult.data;
                    if (by == 6) {
                        this.aguardaSyn = true;
                        return 0;
                    }
                    if (by == 21) continue;
                    this.trace("PPEnvia", "Dado espurio: " + by);
                    return 31;
                }
                this.trace("PPEnvia", "Erro 3 NAKs");
            }
            catch (Exception exception) {
                this.traceException("PPEnvia", exception);
                n = 31;
            }
        }
        return n;
    }

    public int PPEnvia(String string) {
        return this.PPEnvia(PinPadCtrl.AscToBcd(string));
    }

    public int PPRecebe() {
        this.msgBuffer = null;
        if (this.pinpadFechado || driver == null) {
            return -1;
        }
        int n = 0;
        try {
            for (int i = 0; i < 3; ++i) {
                if (this.aguardaSyn) {
                    this.trace("PPRecebe", "Lendo SYN");
                    int n2 = this.modoBlocante ? 10000 : -1;
                    PinPadDriverReadResult<Byte> pinPadDriverReadResult = driver.readSyn(n2);
                    if (pinPadDriverReadResult.error || this.modoBlocante && !pinPadDriverReadResult.complete) {
                        this.PPDesconecta(true);
                        return -1;
                    }
                    if (!this.modoBlocante && !pinPadDriverReadResult.complete) break;
                    this.aguardaSyn = false;
                }
                this.trace("PPRecebe", "Tentativa Leitura: " + i);
                PinPadDriverReadResult<byte[]> pinPadDriverReadResult = driver.readData(2000);
                if (pinPadDriverReadResult.complete && this.validaPacoteCompartilhada((byte[])pinPadDriverReadResult.data) == 1) {
                    this.trace("PPRecebe", "Pacote valido");
                    this.msgBuffer = (byte[])pinPadDriverReadResult.data;
                    n = 0;
                    this.aguardaSyn = true;
                    break;
                }
                this.trace("PPRecebe", "Enviando NAK");
                driver.flush();
                driver.write(new byte[]{21});
                this.aguardaSyn = true;
            }
        }
        catch (Exception exception) {
            this.traceException("PPRecebe", exception);
            n = -1;
            this.PPDesconecta(true);
        }
        return n;
    }

    private int validaPacoteCompartilhada(byte[] byArray) {
        short s;
        int n;
        if (byArray.length < 4 || byArray[0] != 22 || byArray[byArray.length - 3] != 23) {
            return -1;
        }
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (n = 1; n < byArray.length - 2; ++n) {
            s = 1;
            if (byArray[n] == 19 && n + 1 < byArray.length) {
                if (byArray[n + 1] == 51) {
                    byArray2[n2] = 19;
                    ++n;
                    s = 0;
                } else if (byArray[n + 1] == 54) {
                    byArray2[n2] = 22;
                    ++n;
                    s = 0;
                } else if (byArray[n + 1] == 55) {
                    byArray2[n2] = 23;
                    ++n;
                    s = 0;
                }
            }
            if (s != 0) {
                byArray2[n2] = byArray[n];
            }
            ++n2;
        }
        n = PinPadCtrl.crc16(byArray2, 0, n2);
        return n == (s = (short)((byArray[byArray.length - 2] & 0xFF) << 8 | byArray[byArray.length - 1] & 0xFF)) ? 1 : 0;
    }

    public void sendMessage(int n) {
        if (this.hndMessage != null) {
            this.hndMessage.sendEmptyMessage(n);
        }
    }

    public static int obtemIndiceCaractere(byte[] byArray, int n, int n2, int n3) {
        int n4 = -1;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != n3) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    public static String BcdToAsc(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i] >> 4 & 0xF;
            if (n3 >= 0 && n3 <= 9) {
                stringBuffer.append((char)(n3 + 48));
            } else {
                stringBuffer.append((char)(n3 - 10 + 65));
            }
            n3 = byArray[n + i] & 0xF;
            if (n3 >= 0 && n3 <= 9) {
                stringBuffer.append((char)(n3 + 48));
                continue;
            }
            stringBuffer.append((char)(n3 - 10 + 65));
        }
        return stringBuffer.toString();
    }

    public static byte[] AscToBcd(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        byte[] byArray = new byte[n4 / 2];
        for (int i = 0; i < n4; i += 2) {
            n2 = PinPadCtrl.ToBcd(string.charAt(i));
            n3 = PinPadCtrl.ToBcd(string.charAt(i + 1));
            byArray[n++] = (byte)(n3 + (n2 << 4));
        }
        return byArray;
    }

    private static int ToBcd(char c) {
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = (byte)c - 48;
        } else if (c >= 'A' && c <= 'F') {
            n = (byte)c - 65 + 10;
        } else if (c >= 'a' && c <= 'f') {
            n = (byte)c - 97 + 10;
        }
        return n;
    }

    protected static short crc16(byte[] byArray, int n, int n2) {
        return PinPadCtrl.crc16(byArray, n, n2, false);
    }

    protected static short crc16(byte[] byArray, int n, int n2, boolean bl) {
        short s = 0;
        for (int i = 0; i <= n2; ++i) {
            int n3;
            if (i == n2) {
                if (!bl) break;
                n3 = 5888;
            } else {
                n3 = (short)(byArray[n + i] << 8);
            }
            for (int j = 0; j < 8; ++j) {
                if (((s ^ n3) & 0x8000) != 0) {
                    s = (short)(s << 1);
                    s = (short)(s ^ 0x1021);
                } else {
                    s = (short)(s << 1);
                }
                n3 = (short)(n3 << 1);
            }
        }
        return s;
    }

    public void setMessageHandler(Handler handler) {
        this.hndMessage = handler;
    }

    public String getMsgBuffer() {
        return this.msgBuffer == null ? null : PinPadCtrl.BcdToAsc(this.msgBuffer, 0, this.msgBuffer.length);
    }

    public void traceException(String string, Throwable throwable) {
        if (this.logger != null) {
            this.logger.logStackTrace(string, throwable);
        }
    }

    public void traceException(Throwable throwable) {
        this.traceException(LOGTAG, throwable);
    }

    public void trace(String string, @Nullable String string2) {
        if (this.logger != null) {
            this.logger.trace(string, string2);
        }
    }

    static String bcMessageToLogString(byte[] byArray) {
        return PinPadCtrl.bcMessageToLogString(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    static String bcMessageToLogString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(off:" + n + " len:" + n2 + " size:" + byArray.length + ")[");
        for (int i = n; i < n2; ++i) {
            if (byArray[i] < 32) {
                String string;
                switch (byArray[i]) {
                    case 4: {
                        string = "EOT\u2070\u2074";
                        break;
                    }
                    case 6: {
                        string = "ACK\u2070\u2076";
                        break;
                    }
                    case 21: {
                        string = "NAK\u00b9\u2075";
                        break;
                    }
                    case 22: {
                        string = "SYN\u00b9\u2076";
                        break;
                    }
                    case 23: {
                        if (i == byArray.length - 3) {
                            string = String.format("ETB\u00b9\u2077+CRC:%02x%02x", byArray[byArray.length - 2], byArray[byArray.length - 1]);
                            i += 2;
                            break;
                        }
                        string = "ETB\u00b9\u2077";
                        break;
                    }
                    case 24: {
                        string = "CAN\u00b9\u2078";
                        break;
                    }
                    default: {
                        string = String.format("%02x", byArray[i]);
                    }
                }
                stringBuilder.append("\u00ab" + string + "\u00bb");
                continue;
            }
            stringBuilder.append(new String(byArray, i, 1, StandardCharsets.ISO_8859_1));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        driver = null;
    }
}

