/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.AlignmentSpan;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import br.com.softwareexpress.sitef.android.PPMessageHandler;
import br.com.softwareexpress.sitef.android.PinpadDialog;

public class PPFragment
extends DialogFragment {
    private static final String LOGTAG = "PPFragment";
    static final int DISPLAY_HEIGHT = 322;
    static final int DISPLAY_WIDTH = 600;
    private TextView display;
    private String displayText = "";
    private Layout.Alignment displayTextAlign = Layout.Alignment.ALIGN_NORMAL;
    private String displayEntry = "";
    private Layout.Alignment displayEntryAlign = Layout.Alignment.ALIGN_NORMAL;
    protected Button btnF1;
    protected Button btnF2;
    protected Button btnF3;
    protected Button btnF4;
    protected Button btn0;
    protected Button btn1;
    protected Button btn2;
    protected Button btn3;
    protected Button btn4;
    protected Button btn5;
    protected Button btn6;
    protected Button btn7;
    protected Button btn8;
    protected Button btn9;
    protected Button btnCancel;
    protected Button btnClear;
    protected Button btnConfirm;
    protected Activity activity;
    private PPFragment This = this;
    PPMessageHandler ppMessageHandler;
    protected boolean visualAccessibility;
    private boolean isGpos = false;
    private boolean pinpadCreated = false;
    private static boolean pinpadVisible = false;
    private boolean showNumberKeys = false;
    private boolean showFuncKeys = false;
    private int getKeyResult = 10;
    private boolean enabled = true;
    private int menuSelectedItem = -1;
    private int menuStatus = -1;

    public static PPFragment newInstance(Activity activity, PPMessageHandler pPMessageHandler, boolean bl) {
        PPFragment pPFragment = new PPFragment();
        pPFragment.init(activity, pPMessageHandler, bl);
        return pPFragment;
    }

    protected void init(Activity activity, PPMessageHandler pPMessageHandler, boolean bl) {
        this.activity = activity;
        this.ppMessageHandler = pPMessageHandler;
        this.visualAccessibility = bl;
    }

    public static float dpiIndependentDip(float f, DisplayMetrics displayMetrics) {
        return f / displayMetrics.density;
    }

    public void showPinpadDisplayOnly() {
        this.showPinpad(false, false);
    }

    public void showPinpadFuncOnly() {
        this.showPinpad(true, false);
    }

    public void showPinpadNumericOnly() {
        this.showPinpad(false, true);
    }

    public void showPinpad() {
        this.showPinpad(true, true);
    }

    public synchronized void showPinpad(boolean bl, boolean bl2) {
        if (!pinpadVisible) {
            FragmentManager fragmentManager = this.activity.getFragmentManager();
            if (this.pinpadCreated) {
                fragmentManager.beginTransaction().remove((Fragment)this).commit();
                this.pinpadCreated = false;
            }
            this.showNumberKeys = bl2;
            this.showFuncKeys = bl;
            this.getKeyResult = 1;
            this.show(fragmentManager, "Pinpad");
            while (!pinpadVisible) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isPinpadVisible() {
        return pinpadVisible;
    }

    public int getKey() {
        return this.getKeyResult;
    }

    public synchronized void hidePinpad() {
        if (pinpadVisible) {
            pinpadVisible = false;
            this.dismiss();
        }
    }

    private Button createButton(Context context, String string, int n, int n2) {
        Button button = new Button(context);
        button.setText((CharSequence)string);
        button.setTypeface(Typeface.MONOSPACE, n2);
        button.setTextSize(1, PPFragment.dpiIndependentDip(n, context.getResources().getDisplayMetrics()));
        return button;
    }

    protected Button createNumberButton(Context context, String string) {
        return this.createButton(context, string, 60, 1);
    }

    private Button createFunctionButton(Context context, String string, int n, int n2, int n3) {
        final int n4 = n3;
        Button button = this.createButton(context, string, n, n2);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PPFragment.this.getKeyResult = n4;
            }
        });
        return button;
    }

    private Button createFunctionButton(Context context, String string, int n) {
        return this.createFunctionButton(context, string, 50, 0, n);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        WindowManager.LayoutParams layoutParams;
        LinearLayout.LayoutParams layoutParams2;
        LinearLayout linearLayout;
        super.onCreateView(layoutInflater, viewGroup, bundle);
        LinearLayout linearLayout2 = new LinearLayout((Context)this.activity);
        linearLayout2.setOrientation(1);
        this.display = new TextView((Context)this.activity);
        this.display.setText((CharSequence)this.alignedText());
        this.display.setTypeface(Typeface.MONOSPACE);
        this.display.setTextSize(1, PPFragment.dpiIndependentDip(60.0f, this.getResources().getDisplayMetrics()));
        this.display.setPadding(10, 10, 10, 10);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(600, 322);
        layoutParams3.setMargins(30, 0, 30, 0);
        layoutParams3.gravity = 17;
        linearLayout2.addView((View)this.display, (ViewGroup.LayoutParams)layoutParams3);
        int n = Color.argb((int)255, (int)255, (int)0, (int)0);
        int n2 = Color.argb((int)255, (int)240, (int)208, (int)0);
        int n3 = Color.argb((int)255, (int)0, (int)160, (int)0);
        this.btnCancel = this.createFunctionButton((Context)this.activity, "\u2715", 53, 0, 13);
        int n4 = this.btnCancel.getCurrentTextColor();
        int n5 = n4 >> 16 & 0xFF;
        int n6 = n4 >> 8 & 0xFF;
        int n7 = n4 & 0xFF;
        int n8 = n5 + n6 + n7 > 381 ? Color.argb((int)255, (int)255, (int)255, (int)255) : Color.argb((int)255, (int)0, (int)0, (int)0);
        this.btnCancel.setTextColor(n8);
        this.btnCancel.getBackground().setColorFilter(n, PorterDuff.Mode.SRC_IN);
        this.btnClear = this.createFunctionButton((Context)this.activity, "\u25c1", 63, 1, 8);
        this.btnClear.setTextColor(n8);
        this.btnClear.getBackground().setColorFilter(n2, PorterDuff.Mode.SRC_IN);
        this.btnConfirm = this.createFunctionButton((Context)this.activity, "\u25ef", 60, 1, 0);
        this.btnConfirm.setTextColor(n8);
        this.btnConfirm.getBackground().setColorFilter(n3, PorterDuff.Mode.SRC_IN);
        if (this.showFuncKeys) {
            linearLayout = new LinearLayout((Context)this.activity);
            linearLayout.setOrientation(0);
            layoutParams2 = new LinearLayout.LayoutParams(0, -1, 1.0f);
            layoutParams2.setMargins(5, 5, 5, 5);
            this.btnF1 = this.createFunctionButton((Context)this.activity, "F1", 4);
            linearLayout.addView((View)this.btnF1, (ViewGroup.LayoutParams)layoutParams2);
            this.btnF2 = this.createFunctionButton((Context)this.activity, "F2", 5);
            linearLayout.addView((View)this.btnF2, (ViewGroup.LayoutParams)layoutParams2);
            this.btnF3 = this.createFunctionButton((Context)this.activity, "F3", 6);
            linearLayout.addView((View)this.btnF3, (ViewGroup.LayoutParams)layoutParams2);
            this.btnF4 = this.createFunctionButton((Context)this.activity, "F4", 7);
            linearLayout.addView((View)this.btnF4, (ViewGroup.LayoutParams)layoutParams2);
            layoutParams = new LinearLayout.LayoutParams(-1, 120);
            layoutParams.setMargins(10, 5, 10, 5);
            linearLayout2.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
            if (!this.showNumberKeys) {
                LinearLayout linearLayout3 = new LinearLayout((Context)this.activity);
                linearLayout3.setOrientation(0);
                linearLayout3.addView((View)this.btnCancel, (ViewGroup.LayoutParams)layoutParams2);
                linearLayout3.addView((View)this.btnClear, (ViewGroup.LayoutParams)layoutParams2);
                linearLayout3.addView((View)this.btnConfirm, (ViewGroup.LayoutParams)layoutParams2);
                LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, 200);
                layoutParams4.setMargins(10, 0, 10, 10);
                linearLayout2.addView((View)linearLayout3, (ViewGroup.LayoutParams)layoutParams4);
            }
        }
        if (this.showNumberKeys) {
            if (this.visualAccessibility) {
                this.drawNumberKeysForAccessibility(linearLayout2);
            } else {
                this.drawNumberKeys(linearLayout2);
            }
        }
        linearLayout = this.getDialog();
        linearLayout.setOnShowListener(new DialogInterface.OnShowListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onShow(DialogInterface dialogInterface) {
                if (!PPFragment.this.isGpos) {
                    PPFragment pPFragment = PPFragment.this.This;
                    synchronized (pPFragment) {
                        pinpadVisible = true;
                        ((Object)((Object)PPFragment.this.This)).notify();
                    }
                }
            }
        });
        linearLayout.setCanceledOnTouchOutside(false);
        layoutParams2 = linearLayout.getWindow();
        layoutParams = layoutParams2.getAttributes();
        layoutParams.gravity = 48;
        layoutParams.flags &= 0xFFFFFFFD;
        layoutParams2.setAttributes(layoutParams);
        this.pinpadCreated = true;
        return linearLayout2;
    }

    private void drawNumberKeys(LinearLayout linearLayout) {
        TableLayout tableLayout = new TableLayout((Context)this.activity);
        tableLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        tableLayout.setStretchAllColumns(true);
        tableLayout.setPadding(5, 0, 5, 10);
        TableLayout.LayoutParams layoutParams = new TableLayout.LayoutParams(-1, -1, 1.0f);
        TableLayout.LayoutParams layoutParams2 = new TableLayout.LayoutParams(-1, -1, 2.0f);
        TableRow tableRow = new TableRow((Context)this.activity);
        tableRow.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        TableRow tableRow2 = new TableRow((Context)this.activity);
        tableRow2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        TableRow tableRow3 = new TableRow((Context)this.activity);
        tableRow3.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        TableRow tableRow4 = new TableRow((Context)this.activity);
        tableRow4.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        TableRow.LayoutParams layoutParams3 = new TableRow.LayoutParams(-1, -1);
        layoutParams3.setMargins(5, 5, 5, 5);
        this.btn1 = this.createNumberButton((Context)this.activity, "1");
        this.btn2 = this.createNumberButton((Context)this.activity, "2");
        this.btn3 = this.createNumberButton((Context)this.activity, "3");
        this.btn4 = this.createNumberButton((Context)this.activity, "4");
        this.btn5 = this.createNumberButton((Context)this.activity, "5");
        this.btn6 = this.createNumberButton((Context)this.activity, "6");
        this.btn7 = this.createNumberButton((Context)this.activity, "7");
        this.btn8 = this.createNumberButton((Context)this.activity, "8");
        this.btn9 = this.createNumberButton((Context)this.activity, "9");
        this.btn0 = this.createNumberButton((Context)this.activity, "0");
        tableRow.addView((View)this.btn1, (ViewGroup.LayoutParams)layoutParams3);
        tableRow.addView((View)this.btn2, (ViewGroup.LayoutParams)layoutParams3);
        tableRow.addView((View)this.btn3, (ViewGroup.LayoutParams)layoutParams3);
        tableRow2.addView((View)this.btn4, (ViewGroup.LayoutParams)layoutParams3);
        tableRow2.addView((View)this.btn5, (ViewGroup.LayoutParams)layoutParams3);
        tableRow2.addView((View)this.btn6, (ViewGroup.LayoutParams)layoutParams3);
        tableRow3.addView((View)this.btn7, (ViewGroup.LayoutParams)layoutParams3);
        tableRow3.addView((View)this.btn8, (ViewGroup.LayoutParams)layoutParams3);
        tableRow3.addView((View)this.btn9, (ViewGroup.LayoutParams)layoutParams3);
        LinearLayout linearLayout2 = new LinearLayout((Context)this.activity);
        linearLayout2.setOrientation(1);
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        layoutParams4.setMargins(5, 5, 5, 5);
        linearLayout2.addView((View)this.btn0, (ViewGroup.LayoutParams)layoutParams4);
        linearLayout2.addView((View)this.btnClear, (ViewGroup.LayoutParams)layoutParams4);
        TableRow.LayoutParams layoutParams5 = new TableRow.LayoutParams(-1, -1);
        layoutParams5.setMargins(0, 0, 0, 0);
        tableRow4.addView((View)this.btnCancel, (ViewGroup.LayoutParams)layoutParams3);
        tableRow4.addView((View)linearLayout2, (ViewGroup.LayoutParams)layoutParams5);
        tableRow4.addView((View)this.btnConfirm, (ViewGroup.LayoutParams)layoutParams3);
        tableLayout.addView((View)tableRow);
        tableLayout.addView((View)tableRow2);
        tableLayout.addView((View)tableRow3);
        tableLayout.addView((View)tableRow4);
        linearLayout.addView((View)tableLayout);
    }

    protected void drawNumberKeysForAccessibility(LinearLayout linearLayout) {
        this.drawNumberKeys(linearLayout);
    }

    private synchronized Spannable alignedText() {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        int n = 0;
        if (this.displayText.length() > 0) {
            spannableStringBuilder.append((CharSequence)this.displayText);
            spannableStringBuilder.setSpan((Object)new AlignmentSpan.Standard(this.displayTextAlign), n, spannableStringBuilder.length(), 33);
        }
        if (this.displayEntry != null && this.displayEntry.length() > 0) {
            n = spannableStringBuilder.length();
            spannableStringBuilder.append((CharSequence)this.displayEntry);
            spannableStringBuilder.setSpan((Object)new AlignmentSpan.Standard(this.displayEntryAlign), n, spannableStringBuilder.length(), 33);
        }
        return spannableStringBuilder;
    }

    public void showText(String string) {
        this.showText(string, Layout.Alignment.ALIGN_NORMAL);
    }

    public synchronized void showText(String string, Layout.Alignment alignment) {
        this.showText(string, alignment, null, Layout.Alignment.ALIGN_NORMAL);
    }

    public synchronized void showText(String string, Layout.Alignment alignment, String string2, Layout.Alignment alignment2) {
        this.displayText = string.replace('\r', '\n');
        this.displayTextAlign = alignment;
        this.displayEntry = string2;
        this.displayEntryAlign = alignment2;
        final Spannable spannable = this.alignedText();
        if (this.ppMessageHandler != null) {
            this.ppMessageHandler.logCardholderMessage(spannable);
        }
        if (this.pinpadCreated) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PPFragment.this.display.setText((CharSequence)spannable);
                }
            });
        }
    }

    public void setPinpadEnabled(boolean bl) {
        this.enabled = bl;
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (PPFragment.this.pinpadCreated) {
                    PPFragment.this.btnCancel.setEnabled(PPFragment.this.enabled);
                    PPFragment.this.btnClear.setEnabled(PPFragment.this.enabled);
                    PPFragment.this.btnConfirm.setEnabled(PPFragment.this.enabled);
                    if (PPFragment.this.showFuncKeys) {
                        PPFragment.this.btnF1.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btnF2.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btnF3.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btnF4.setEnabled(PPFragment.this.enabled);
                    }
                    if (PPFragment.this.showNumberKeys) {
                        PPFragment.this.btn0.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn1.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn2.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn3.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn4.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn5.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn6.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn7.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn8.setEnabled(PPFragment.this.enabled);
                        PPFragment.this.btn9.setEnabled(PPFragment.this.enabled);
                    }
                }
            }
        });
    }

    public Dialog onCreateDialog(Bundle bundle) {
        Dialog dialog = super.onCreateDialog(bundle);
        dialog.getWindow().requestFeature(1);
        return dialog;
    }

    public void onStart() {
        Dialog dialog;
        super.onStart();
        if (this.showNumberKeys && (dialog = this.getDialog()) != null) {
            Rect rect = new Rect();
            View view = this.getActivity().getWindow().getDecorView();
            view.getWindowVisibleDisplayFrame(rect);
            int n = view.getHeight() - rect.top;
            int n2 = view.getWidth();
            dialog.getWindow().setLayout(n2, n);
        }
    }

    public void onResume() {
        super.onResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDismiss(DialogInterface dialogInterface) {
        PPFragment pPFragment = this;
        synchronized (pPFragment) {
            pinpadVisible = false;
            this.showFuncKeys = false;
            this.showNumberKeys = false;
            this.getKeyResult = 13;
        }
    }

    public void execMenu(String string, String[] stringArray) {
        this.menuSelectedItem = -1;
        this.menuStatus = -1;
        int n = PinpadDialog.execMenu(this.activity, string, stringArray);
        if (n >= 0) {
            this.menuSelectedItem = n;
            this.menuStatus = 0;
        } else if (n == -1) {
            this.menuStatus = 13;
        } else if (n == -2) {
            this.menuStatus = 12;
        }
    }

    public int getMenuSelectedItem() {
        return this.menuSelectedItem;
    }

    public int getMenuStatus() {
        return this.menuStatus;
    }

    public static void setPinpadVisible(boolean bl) {
        pinpadVisible = bl;
    }

    public static boolean getPinpadVisible() {
        return pinpadVisible;
    }

    public PPFragment getThis() {
        return this.This;
    }

    public void setThis(PPFragment pPFragment) {
        this.This = pPFragment;
    }

    public void setIsGpos(boolean bl) {
        this.isGpos = bl;
    }
}

