/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.app.Activity;
import android.util.Log;
import br.com.gertec.ppcomp.PPComp;
import br.com.gertec.ppcomp.PPCompException;
import br.com.gertec.ppcomp.exceptions.PPCompNotifyException;
import br.com.gertec.ppcomp.exceptions.PPCompProcessingException;
import br.com.softwareexpress.sitef.android.CliSiTefI;
import br.com.softwareexpress.sitef.android.IPPCompLib;
import br.com.softwareexpress.sitef.android.PPFragmentGpos700;
import br.com.softwareexpress.sitef.android.PPMessageHandler;

class PPCompLib
implements IPPCompLib {
    private static final String LOGTAG = "PPCompLibGertec";
    private static PPComp ppcomp;
    private final PPFragmentGpos700 ppFragment;
    private final PPMessageHandler ppMessageHandler;
    private boolean GcrGocStartThread = true;
    private String GcrGocOutput;
    private int GcrGocStatus = 10;

    public PPCompLib(Activity activity, PPMessageHandler pPMessageHandler, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("CliSiTef/PPCompLib: no Activity set (application must call CliSiTef/CliSiTefI.setActivity()).");
        }
        this.ppMessageHandler = pPMessageHandler;
        try {
            if (ppcomp == null) {
                ppcomp = new PPComp(activity.getApplicationContext());
            }
            this.ppFragment = PPFragmentGpos700.newInstance(activity, ppcomp, pPMessageHandler, bl);
        }
        catch (PPCompException pPCompException) {
            CliSiTefI.logStackTrace(pPCompException);
            throw new Error(pPCompException.getMessage());
        }
    }

    private void setCtlsKernelVerions() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        try {
            String string8 = ppcomp.PP_GetCtlsVersion();
            int n = Integer.parseInt(string8.substring(2, 4));
            string2 = string8.substring(4, 4 + n);
            n = Integer.parseInt(string8.substring(20, 22));
            string4 = string8.substring(22, 22 + n);
            n = Integer.parseInt(string8.substring(38, 40));
            string3 = string8.substring(40, 40 + n);
            n = Integer.parseInt(string8.substring(56, 58));
            string5 = string8.substring(58, 58 + n);
            n = Integer.parseInt(string8.substring(74, 76));
            string6 = string8.substring(76, 76 + n);
            n = Integer.parseInt(string8.substring(110, 112));
            string7 = string8.substring(112, 112 + n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            CliSiTefI.logStackTrace("SCKV", throwable);
        }
        try {
            CliSiTefI.getInstance().setAndroidEmvKernelVersions(string, string2, string3, string4, string5, string6, string7);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            CliSiTefI.logStackTrace("SCKV", throwable);
        }
    }

    @Override
    public int PP_Open() {
        int n = 0;
        try {
            ppcomp.PP_Open();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_Close(String string) {
        int n = 0;
        try {
            ppcomp.PP_Close(String.format("%-32s", string));
            this.ppFragment.hidePinpad();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_Abort() {
        int n = 0;
        try {
            this.ppFragment.hidePinpad();
            ppcomp.PP_Abort();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GetInfo(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string2 = ppcomp.PP_GetInfo(string);
            if (string.contains("00") && !string2.contains("GERTEC")) {
                try {
                    Thread.sleep(700L);
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)"PPCompLib", (String)"PP_GetInfo sleep exception");
                }
                string2 = ppcomp.PP_GetInfo(string);
            }
            if (string.equals("03")) {
                try {
                    String string3 = ppcomp.PP_GetCtlsVersion();
                    int n2 = Integer.parseInt(string3.substring(2, 4));
                    String string4 = string3.substring(4, 4 + n2).replaceAll("[.]", "");
                    n2 = Integer.parseInt(string3.substring(20, 22));
                    String string5 = string3.substring(22, 22 + n2);
                    n2 = Integer.parseInt(string3.substring(38, 40));
                    String string6 = string3.substring(40, 40 + n2);
                    String string7 = string2.substring(10, 14).trim();
                    String string8 = string2.substring(14, 17).trim();
                    String string9 = string2.substring(17, 20).trim();
                    boolean bl = false;
                    if (string7.isEmpty()) {
                        string7 = string4;
                        bl = true;
                    }
                    if (string8.isEmpty()) {
                        string8 = string6;
                        bl = true;
                    }
                    if (string9.isEmpty()) {
                        string9 = string5;
                        bl = true;
                    }
                    string2 = string2.substring(0, 10) + String.format("%-4.4s%-3.3s%-3.3s", string7, string8, string9) + string2.substring(20);
                    if (bl) {
                        CliSiTefI.trace("jGIN", "Versoes de kernel ctls introduzidas no GetInfo.");
                    }
                }
                catch (Throwable throwable) {
                    CliSiTefI.logStackTrace("jGIN", throwable);
                    CliSiTefI.trace("jGIN", "Erro ao obter versoes de kernel ctls.");
                }
            }
            stringBuffer.append(string2);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_Display(String string) {
        int n = 0;
        try {
            ppcomp.PP_Display(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_DisplayEx(String string) {
        int n = 0;
        try {
            ppcomp.PP_DisplayEx(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_StartGetKey() {
        int n = 0;
        try {
            ppcomp.PP_StartGetKey();
            this.ppFragment.showPinpadNumericOnly();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GetKey() {
        int n = 0;
        try {
            n = ppcomp.PP_GetKey();
            this.ppFragment.hidePinpad();
        }
        catch (PPCompProcessingException pPCompProcessingException) {
            n = pPCompProcessingException.getErrorCode();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
            this.ppFragment.hidePinpad();
        }
        return n;
    }

    @Override
    public int PP_StartGetPIN(String string) {
        int n = 0;
        try {
            ppcomp.PP_StartGetPIN(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GetPIN(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = 0;
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        try {
            String string = ppcomp.PP_GetPIN();
            stringBuffer.append(string);
            this.ppFragment.hidePinpad();
        }
        catch (PPCompNotifyException pPCompNotifyException) {
            stringBuffer2.append(pPCompNotifyException.getMsgNotify());
            n = pPCompNotifyException.getErrorCode();
        }
        catch (PPCompProcessingException pPCompProcessingException) {
            n = pPCompProcessingException.getErrorCode();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
            this.ppFragment.hidePinpad();
        }
        return n;
    }

    @Override
    public int PP_StartCheckEvent(String string) {
        int n = 0;
        try {
            ppcomp.PP_StartCheckEvent(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_CheckEvent(StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string = ppcomp.PP_CheckEvent();
            stringBuffer.append(string);
            this.ppFragment.hidePinpad();
        }
        catch (PPCompProcessingException pPCompProcessingException) {
            n = pPCompProcessingException.getErrorCode();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
            this.ppFragment.hidePinpad();
        }
        return n;
    }

    @Override
    public int PP_StartRemoveCard(String string) {
        int n = 0;
        try {
            ppcomp.PP_StartRemoveCard(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_RemoveCard(StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            ppcomp.PP_RemoveCard();
        }
        catch (PPCompNotifyException pPCompNotifyException) {
            stringBuffer.append(pPCompNotifyException.getMsgNotify());
            n = pPCompNotifyException.getErrorCode();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    private int startGcrGoc(String string, String string2, String string3) {
        int n = 0;
        if (!this.GcrGocStartThread) {
            this.GcrGocStartThread = true;
            try {
                ppcomp.PP_Abort();
            }
            catch (PPCompException pPCompException) {
                // empty catch block
            }
        }
        this.GcrGocOutput = null;
        this.GcrGocStatus = 1;
        try {
            if (string == null) {
                ppcomp.PP_ResumeGetCard();
            } else if (string2 == null) {
                ppcomp.PP_StartGetCard(string);
            } else {
                ppcomp.PP_StartGoOnChip(string, string2, string3);
            }
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    private int gcrGoc(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        int n;
        final boolean bl2 = bl;
        if (this.GcrGocStartThread) {
            this.GcrGocStartThread = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = bl2 ? ppcomp.PP_GetCard() : ppcomp.PP_GoOnChip();
                        PPCompLib.this.GcrGocOutput = string;
                        PPCompLib.this.GcrGocStatus = 0;
                        PPCompLib.this.ppFragment.hidePinpad();
                    }
                    catch (PPCompNotifyException pPCompNotifyException) {
                        PPCompLib.this.GcrGocStartThread = true;
                        PPCompLib.this.ppMessageHandler.handleNotifyMessage(pPCompNotifyException.getMsgNotify());
                    }
                    catch (PPCompProcessingException pPCompProcessingException) {
                        PPCompLib.this.GcrGocStartThread = true;
                    }
                    catch (PPCompException pPCompException) {
                        Log.e((String)PPCompLib.LOGTAG, (String)("PP_GetCard/GoOnChip exception: " + (Object)((Object)pPCompException)));
                        PPCompLib.this.GcrGocStatus = pPCompException.getErrorCode();
                        PPCompLib.this.ppFragment.hidePinpad();
                    }
                }
            }).start();
        }
        if (this.GcrGocStatus == 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(this.GcrGocOutput);
            n = 0;
        } else {
            n = this.GcrGocStatus;
        }
        if (n != 1) {
            this.GcrGocStatus = 10;
            this.GcrGocStartThread = true;
        }
        return n;
    }

    @Override
    public int PP_StartGetCard(String string) {
        return this.startGcrGoc(string, null, null);
    }

    @Override
    public int PP_GetCard(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.gcrGoc(stringBuffer, stringBuffer2, true);
    }

    @Override
    public int PP_ResumeGetCard() {
        return this.startGcrGoc(null, null, null);
    }

    @Override
    public int PP_StartGoOnChip(String string, String string2, String string3) {
        return this.startGcrGoc(string, string2, string3);
    }

    @Override
    public int PP_GoOnChip(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.gcrGoc(stringBuffer, stringBuffer2, false);
    }

    @Override
    public int PP_FinishChip(String string, String string2, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string3 = ppcomp.PP_FinishChip(string, string2);
            stringBuffer.append(string3);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_ChangeParameter(String string) {
        int n = 0;
        try {
            ppcomp.PP_ChangeParameter(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_EncryptBuffer(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string2 = ppcomp.PP_EncryptBuffer(string);
            stringBuffer.append(string2);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_DefineWKPAN(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string2 = ppcomp.PP_DefineWKPAN(string);
            stringBuffer.append(string2);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_TableLoadInit(String string) {
        int n = 0;
        try {
            ppcomp.PP_TableLoadInit(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_TableLoadRec(String string) {
        int n = 0;
        try {
            ppcomp.PP_TableLoadRec(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_TableLoadEnd() {
        int n = 0;
        try {
            ppcomp.PP_TableLoadEnd();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GetTimeStamp(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string2 = ppcomp.PP_GetTimeStamp(string);
            stringBuffer.append(string2);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GetDUKPT(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string2 = ppcomp.PP_GetDUKPT(string);
            stringBuffer.append(string2);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_StartGenericCmd(String string) {
        int n = 0;
        try {
            ppcomp.PP_StartGenericCmd(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_GenericCmd(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = 0;
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        try {
            String string = ppcomp.PP_GenericCmd();
            stringBuffer.append(string);
        }
        catch (PPCompNotifyException pPCompNotifyException) {
            stringBuffer2.append(pPCompNotifyException.getMsgNotify());
            n = pPCompNotifyException.getErrorCode();
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_StartChipDirect(String string) {
        int n = 0;
        try {
            ppcomp.PP_StartChipDirect(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }

    @Override
    public int PP_ChipDirect(StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        try {
            String string = ppcomp.PP_ChipDirect();
            stringBuffer.append(string);
        }
        catch (PPCompException pPCompException) {
            n = pPCompException.getErrorCode();
        }
        return n;
    }
}

