/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.android;

import android.content.Context;
import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.softwareexpress.sitef.android.CliSiTefI;
import br.com.softwareexpress.sitef.android.IComunicacaoExterna;
import br.com.softwareexpress.sitef.android.Parametros;
import br.com.softwareexpress.sitef.android.PinPadCtrl;

final class GerComunicacao {
    private static final int COMUNICACAO_INDEFINIDA = 0;
    private int porta = 4096;
    private int tipoComunicacao = 0;
    private String ip = "";
    private IComunicacaoExterna driver = null;
    private final Context context;
    private final Parametros listaParametros;
    private final JCliSiTefI clisitefi;

    public GerComunicacao(JCliSiTefI jCliSiTefI, Context context) {
        this.context = context;
        this.clisitefi = jCliSiTefI;
        this.listaParametros = new Parametros();
    }

    private void log(String string) {
        this.clisitefi.pinPadBTExecuta(80, string);
        CliSiTefI.log("GerComunicacao", string);
    }

    public final void setIP(String string) {
        this.ip = string;
    }

    public final void setPorta(int n) {
        this.porta = n;
    }

    public final void setParametros(String string, String string2) {
        this.listaParametros.setParametro(string, string2);
    }

    public final void setTipoComunicacao(String string) {
        this.tipoComunicacao = 0;
        if (string != null) {
            // empty if block
        }
    }

    public final int conecta() throws Exception {
        switch (this.tipoComunicacao) {
            default: 
        }
        this.driver = null;
        int n = this.driver != null ? this.driver.conecta(this.ip, this.porta, this.listaParametros) : -1;
        this.log("conecta: " + n);
        return n;
    }

    public final int desconecta() {
        int n = this.driver != null ? this.driver.desconecta() : -1;
        this.driver = null;
        return n;
    }

    public final int enviaRecebeMensagem() throws Exception {
        if (this.driver == null) {
            return -1;
        }
        try {
            String string = this.clisitefi.getBuffer();
            byte[] byArray = PinPadCtrl.AscToBcd(string);
            this.driver.envia(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[20000];
            int n = 0;
            n += this.driver.recebe(byArray2, n, 2);
            if (n != 2) {
                n += this.driver.recebe(byArray2, n, 2 - n);
            }
            if (n != 2) {
                this.clisitefi.setContinuaNavegacao(-1);
                return -1;
            }
            int n2 = (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF;
            while ((n += this.driver.recebe(byArray2, n, byArray2.length - n)) < n2) {
            }
            string = PinPadCtrl.BcdToAsc(byArray2, 0, n);
            this.clisitefi.setBuffer(string);
        }
        catch (Exception exception) {
            this.clisitefi.setContinuaNavegacao(-1);
            CliSiTefI.logStackTrace(exception);
        }
        return 0;
    }
}

