/*
 * Decompiled with CFR 0.152.
 */
package com.datasul.printer;

import com.datasul.printer.ConfigData;
import com.datasul.printer.ConfigHandler;
import com.datasul.printer.GDIPrinter;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import javax.print.PrintService;
import sun.print.Win32PrintServiceLookup;

public class Redirector {
    private static InputStream XmlFile;
    public Vector printers;
    public static ConfigData printersConfig;
    String excludeFile;
    String command;
    String printer;
    String name;
    String port;
    GDIPrinter gdiPrinter;

    public static void main(String[] args) throws IOException {
        Redirector redict = new Redirector();
        XmlFile = ClassLoader.getSystemResourceAsStream("config.xml");
        if (XmlFile == null) {
            try {
                XmlFile = new FileInputStream("config.xml");
            }
            catch (FileNotFoundException e) {
                Redirector.log("loggdi.lg", "Arquivo de configura\u00e7\u00e3o n\u00e3o est\u00e1 presente no JAR");
            }
            printersConfig = ConfigHandler.setConfig(XmlFile);
        } else {
            printersConfig = ConfigHandler.setConfig(XmlFile);
        }
        if (printersConfig != null) {
            try {
                boolean ret = redict.startListener();
            }
            catch (IOException ioe) {
                Redirector.log("loggdi.lg", "Erro ao iniciar o Listener");
            }
        } else {
            Redirector.log("loggdi.lg", "Parser XML retornou valor inv\u00e1lido");
        }
    }

    public boolean startListener() throws IOException {
        this.printers = printersConfig.getGdiPrinter();
        this.command = printersConfig.getDatasulGDIPath();
        this.excludeFile = printersConfig.getExcludeFile();
        int i = 0;
        while (i < this.printers.size()) {
            this.gdiPrinter = (GDIPrinter)this.printers.get(i);
            ListenerStarter listener = new ListenerStarter(this.gdiPrinter);
            listener.start();
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String file, String msg) {
        String[] ids = TimeZone.getAvailableIDs(-10800000);
        SimpleTimeZone pdt = new SimpleTimeZone(-10800000, ids[0]);
        GregorianCalendar calendar = new GregorianCalendar(pdt);
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        String dataHora = String.valueOf(calendar.get(5)) + "/" + calendar.get(2) + "/" + calendar.get(1);
        int hora = calendar.get(11);
        dataHora = calendar.get(12) > 9 ? String.valueOf(dataHora) + " - " + hora + ":" + calendar.get(12) + " - " : String.valueOf(dataHora) + " - " + hora + ":0" + calendar.get(12) + " - ";
        try {
            PrintStream logFile = new PrintStream(new FileOutputStream(file, true));
            try {
                logFile.println(String.valueOf(dataHora) + msg);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                logFile.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
                logFile.close();
                return;
            }
        }
        catch (IOException ex) {
            System.err.println("Problemas ao criar arquivo de log + " + file);
        }
    }

    public class ListenerStarter
    extends Thread {
        GDIPrinter gdiPrinter;

        public ListenerStarter(GDIPrinter gdiPrinter) {
            this.gdiPrinter = gdiPrinter;
        }

        public void run() {
            try {
                this.starter(Integer.parseInt(this.gdiPrinter.getPort()), this.gdiPrinter.getName());
            }
            catch (IOException e) {
                Redirector.log("loggdi.lg", "Problemas ao iniciar Listener");
            }
        }

        public boolean starter(int port, String printer) throws IOException {
            try {
                ServerSocket server = new ServerSocket(port);
                while (true) {
                    Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Escutando Porta: " + port);
                    Socket socket = server.accept();
                    Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Novo arquivo encontrado em: " + port + " para impressora " + printer);
                    try {
                        boolean ret;
                        int len;
                        boolean exclude = false;
                        Redirector.this.command = printersConfig.getDatasulGDIPath();
                        InputStream in = socket.getInputStream();
                        String file = String.valueOf(System.currentTimeMillis()) + ".esc";
                        File fileObject = new File(file);
                        fileObject.createNewFile();
                        exclude = printersConfig.getExcludeFile().trim().equalsIgnoreCase("yes");
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileObject));
                        byte[] buffer = new byte[1024];
                        while ((len = in.read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        ((OutputStream)out).close();
                        FileReader reader = new FileReader(file);
                        BufferedReader bfreader = new BufferedReader(reader);
                        String line = bfreader.readLine();
                        line = line == null ? "" : line;
                        bfreader.close();
                        if (line.indexOf(String.valueOf(String.valueOf('\u001b')) + String.valueOf('\u001b')) >= 0) {
                            Redirector.this.command = String.valueOf(Redirector.this.command) + " /land ";
                            if (line.indexOf(String.valueOf(String.valueOf('\u001b')) + String.valueOf('g')) >= 0) {
                                Redirector.this.command = String.valueOf(Redirector.this.command) + " /fit66% ";
                            }
                        } else if (line.indexOf(String.valueOf(String.valueOf('\u001b')) + String.valueOf('M') + String.valueOf('\u001b') + String.valueOf('\u000f')) >= 0 || line.indexOf(String.valueOf(String.valueOf('\u001b')) + String.valueOf('M') + String.valueOf('\u000f')) >= 0) {
                            Redirector.this.command = String.valueOf(Redirector.this.command) + " /fit90%";
                        }
                        String printerName = this.gdiPrinter.getName().trim();
                        if (this.gdiPrinter.getName().trim().toLowerCase().equals("principal")) {
                            if (PrinterJob.lookupPrintServices().length > 0) {
                                String nm = System.getProperty("java.awt.printerjob", null);
                                if (nm.equalsIgnoreCase("sun.awt.windows.WPrinterJob")) {
                                    Win32PrintServiceLookup wpsl = new Win32PrintServiceLookup();
                                    PrintService ps = wpsl.getDefaultPrintService();
                                    printerName = ps.getName();
                                    Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "A impressora " + ps.getName() + " foi definida como default.");
                                } else {
                                    Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Erro ao utilizar a propriedade default, pois o print service " + nm + " n\u00e3o \u00e9 comp\u00e1tivel!");
                                }
                            } else {
                                Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Erro ao utilizar a propriedade default, pois nenhuma impressora est\u00e1 definida como padr\u00e3o!");
                            }
                        }
                        Redirector.this.command = String.valueOf(Redirector.this.command) + " /CP1252 /SEL'" + printerName + "' " + "\"" + fileObject.getAbsolutePath() + "\"";
                        Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Usando GDI? " + this.gdiPrinter.getUseGDI());
                        if (this.gdiPrinter.getUseGDI().equals(new Boolean("false"))) {
                            RandomAccessFile fileToPrint = new RandomAccessFile(fileObject, "r");
                            if (fileToPrint.length() > 0L) {
                                char[] conteudo = new char[(int)fileToPrint.length()];
                                int i = 0;
                                while ((long)i < fileToPrint.length()) {
                                    conteudo[i] = (char)fileToPrint.read();
                                    ++i;
                                }
                                FileOutputStream printerOutput = new FileOutputStream(this.gdiPrinter.getName().trim());
                                PrintStream printerStream = new PrintStream(printerOutput);
                                if (!conteudo.toString().equals("")) {
                                    printerStream.print(conteudo);
                                }
                            }
                        } else {
                            Runtime e = Runtime.getRuntime();
                            try {
                                Process p = e.exec(Redirector.this.command);
                                p.waitFor();
                            }
                            catch (InterruptedException e1) {
                                Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", e1.getMessage());
                                e1.printStackTrace();
                            }
                        }
                        if (exclude && !(ret = fileObject.delete())) {
                            Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Arquivo n\u00e3o pode ser exclu\u00eddo");
                        }
                        socket.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", ioe.getMessage());
                    }
                }
            }
            catch (BindException ioe) {
                Redirector.log("loggdi " + this.gdiPrinter.getPort() + ".lg", "Porta em uso");
                return false;
            }
        }
    }
}

