/*
 * Decompiled with CFR 0.152.
 */
package com.datasul.printer;

import com.datasul.printer.ConfigData;
import com.datasul.printer.GDIPrinter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigHandler {
    private Document document;
    private ConfigData data;
    private static ConfigHandler config;

    private ConfigHandler(InputStream file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(file);
        this.start();
    }

    private void start() {
        Element root = this.document.getDocumentElement();
        NodeList records = root.getChildNodes();
        this.data = new ConfigData();
        if (root.getNodeName().equals("DatasulGDI")) {
            this.getRecordValues(records);
        }
    }

    private void getRecordValues(NodeList record) {
        int i = 0;
        while (i < record.getLength()) {
            if (record.item(i).hasChildNodes()) {
                this.getRecordValues(record.item(i).getChildNodes());
            } else if (record.item(i).getNodeType() == 3 || record.item(i).getNodeType() == 1) {
                Node node = record.item(i);
                if (record.item(i).hasAttributes()) {
                    GDIPrinter printer = new GDIPrinter();
                    NamedNodeMap atributos = record.item(i).getAttributes();
                    Node port = atributos.getNamedItem("port");
                    printer.setPort(port.getNodeValue());
                    Node name = atributos.getNamedItem("name");
                    printer.setName(name.getNodeValue());
                    Node useGDI = atributos.getNamedItem("useGDI");
                    if (useGDI == null) {
                        printer.setUseGDI(new Boolean("true"));
                    } else {
                        printer.setUseGDI(new Boolean(name.getNodeValue() == null ? "true" : node.getNodeValue()));
                    }
                    this.data.setGdiPrinter(printer);
                } else {
                    if (node.getParentNode().getNodeName().equals("ExcludeFile")) {
                        this.data.setExcludeFile(node.getNodeValue());
                    }
                    if (node.getParentNode().getNodeName().equals("DatasulGDIPath")) {
                        this.data.setDatasulGDIPath(node.getNodeValue());
                    }
                }
            }
            ++i;
        }
    }

    public static ConfigData setConfig(InputStream file) {
        if (config == null) {
            try {
                config = new ConfigHandler(file);
            }
            catch (ParserConfigurationException e) {
                System.out.println("Formato do arquivo XML inv\u00e1lido");
            }
            catch (SAXException e) {
                System.out.println("Formato do arquivo XML inv\u00e1lido");
            }
            catch (IOException e) {
                System.out.println("Formato do arquivo XML inv\u00e1lido");
            }
        }
        return config.getConfig();
    }

    private ConfigData getConfig() {
        return this.data;
    }
}

